/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.util.representation;

import it.unive.lisa.outputs.serializableGraph.SerializableObject;
import it.unive.lisa.outputs.serializableGraph.SerializableValue;
import it.unive.lisa.util.StringUtilities;
import it.unive.lisa.util.representation.StructuredRepresentation;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;

public class ObjectRepresentation
extends StructuredRepresentation {
    protected final SortedMap<String, StructuredRepresentation> fields;

    public <V> ObjectRepresentation(Map<String, V> fields, Function<V, StructuredRepresentation> mapper) {
        this.fields = new TreeMap<String, StructuredRepresentation>();
        for (Map.Entry<String, V> e : fields.entrySet()) {
            this.fields.put(e.getKey(), mapper.apply(e.getValue()));
        }
    }

    public ObjectRepresentation(Map<String, StructuredRepresentation> map) {
        this.fields = map instanceof SortedMap ? (SortedMap<Object, Object>)map : new TreeMap<String, StructuredRepresentation>(map);
    }

    @Override
    public SerializableValue toSerializableValue() {
        TreeMap<String, SerializableValue> fields = new TreeMap<String, SerializableValue>();
        for (Map.Entry<String, StructuredRepresentation> e : this.fields.entrySet()) {
            fields.put(e.getKey(), e.getValue().toSerializableValue());
        }
        return new SerializableObject(this.getProperties(), fields);
    }

    @Override
    public String toString() {
        if (this.fields.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder("{");
        boolean first = true;
        for (Map.Entry<String, StructuredRepresentation> e : this.fields.entrySet()) {
            String val = e.getValue().toString();
            if (!val.contains("\n")) {
                sb.append(first ? "\n  " : ",\n  ").append(e.getKey()).append(": ").append(e.getValue());
            } else {
                sb.append(first ? "\n  " : ",\n  ").append(e.getKey()).append(":\n").append(StringUtilities.indent(val, "  ", 2));
            }
            first = false;
        }
        sb.append("\n}");
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.fields == null ? 0 : this.fields.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ObjectRepresentation other = (ObjectRepresentation)obj;
        return !(this.fields == null ? other.fields != null : !this.fields.equals(other.fields));
    }
}

