/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.util.representation;

import it.unive.lisa.outputs.serializableGraph.SerializableObject;
import it.unive.lisa.outputs.serializableGraph.SerializableValue;
import it.unive.lisa.util.StringUtilities;
import it.unive.lisa.util.representation.StructuredRepresentation;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;

public class MapRepresentation
extends StructuredRepresentation {
    protected final SortedMap<StructuredRepresentation, StructuredRepresentation> map;

    public <K, V> MapRepresentation(Map<K, V> map, Function<K, StructuredRepresentation> keyMapper, Function<V, StructuredRepresentation> valueMapper) {
        this.map = new TreeMap<StructuredRepresentation, StructuredRepresentation>();
        for (Map.Entry<K, V> e : map.entrySet()) {
            this.map.put(keyMapper.apply(e.getKey()), valueMapper.apply(e.getValue()));
        }
    }

    public MapRepresentation(Map<StructuredRepresentation, StructuredRepresentation> map) {
        this.map = map instanceof SortedMap ? (SortedMap<Object, Object>)map : new TreeMap<StructuredRepresentation, StructuredRepresentation>(map);
    }

    @Override
    public SerializableValue toSerializableValue() {
        TreeMap<String, SerializableValue> fields = new TreeMap<String, SerializableValue>();
        for (Map.Entry<StructuredRepresentation, StructuredRepresentation> e : this.map.entrySet()) {
            fields.put(e.getKey().toString(), e.getValue().toSerializableValue());
        }
        return new SerializableObject(this.getProperties(), fields);
    }

    @Override
    public String toString() {
        if (this.map.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder("{");
        boolean first = true;
        for (Map.Entry<StructuredRepresentation, StructuredRepresentation> e : this.map.entrySet()) {
            String key = e.getKey().toString();
            String val = e.getValue().toString();
            if (!key.contains("\n") && !val.contains("\n")) {
                sb.append(first ? "\n  " : ",\n  ").append(key).append(": ").append(val);
            } else {
                sb.append(first ? "\n  " : ",\n  ").append(StringUtilities.indent(key, "  ", 1)).append(":\n").append(StringUtilities.indent(val, "  ", 2));
            }
            first = false;
        }
        sb.append("\n}");
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.map == null ? 0 : this.map.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MapRepresentation other = (MapRepresentation)obj;
        return !(this.map == null ? other.map != null : !this.map.equals(other.map));
    }
}

