/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.util.representation;

import it.unive.lisa.outputs.serializableGraph.SerializableArray;
import it.unive.lisa.outputs.serializableGraph.SerializableValue;
import it.unive.lisa.util.StringUtilities;
import it.unive.lisa.util.representation.StructuredRepresentation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ListRepresentation
extends StructuredRepresentation {
    protected final List<StructuredRepresentation> elements;

    public <E> ListRepresentation(List<E> elements, Function<E, StructuredRepresentation> mapper) {
        this(elements.stream().map(mapper).collect(Collectors.toList()));
    }

    public ListRepresentation(List<StructuredRepresentation> elements) {
        this.elements = elements;
    }

    public ListRepresentation(StructuredRepresentation ... elements) {
        this.elements = Arrays.asList(elements);
    }

    @Override
    public SerializableValue toSerializableValue() {
        ArrayList<SerializableValue> values = new ArrayList<SerializableValue>(this.elements.size());
        for (StructuredRepresentation e : this.elements) {
            values.add(e.toSerializableValue());
        }
        return new SerializableArray(this.getProperties(), values);
    }

    @Override
    public String toString() {
        if (this.elements.isEmpty()) {
            return "[]";
        }
        List strs = this.elements.stream().map(Object::toString).collect(Collectors.toList());
        if (strs.stream().noneMatch(s -> s.contains("\n"))) {
            return "[" + StringUtils.join(strs, (String)", ") + "]";
        }
        StringBuilder sb = new StringBuilder("[");
        boolean first = true;
        for (String e : strs) {
            sb.append(first ? "\n" : ",\n").append(StringUtilities.indent(e.toString(), "  ", 1));
            first = false;
        }
        sb.append("\n]");
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.elements == null ? 0 : this.elements.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ListRepresentation other = (ListRepresentation)obj;
        return !(this.elements == null ? other.elements != null : !this.elements.equals(other.elements));
    }
}

