/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.util.numeric;

import it.unive.lisa.util.collections.CollectionUtilities;
import it.unive.lisa.util.numeric.MathNumberConversionException;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class MathNumber
implements Comparable<MathNumber> {
    public static final MathNumber PLUS_INFINITY = new MathNumber(1);
    public static final MathNumber MINUS_INFINITY = new MathNumber(-1);
    public static final MathNumber ZERO = new MathNumber(0L);
    public static final MathNumber ONE = new MathNumber(1L);
    public static final MathNumber MINUS_ONE = new MathNumber(-1L);
    public static final MathNumber NaN = new MathNumber(3);
    private final BigDecimal number;
    private final byte sign;

    public MathNumber(long number) {
        this.number = BigDecimal.valueOf(number);
        this.sign = number > 0L ? 1 : (number == 0L ? 0 : -1);
    }

    public MathNumber(double number) {
        this.number = BigDecimal.valueOf(number);
        this.sign = number > 0.0 ? 1 : (number == 0.0 ? 0 : -1);
    }

    public MathNumber(BigDecimal number) {
        this.number = number;
        this.sign = number.signum() > 0 ? 1 : (number.signum() == 0 ? 0 : -1);
    }

    private MathNumber(byte sign) {
        this.number = null;
        this.sign = sign;
    }

    public boolean isMinusInfinity() {
        return this.number == null && this.isNegative();
    }

    public boolean isPlusInfinity() {
        return this.number == null && this.isPositive();
    }

    public boolean isInfinite() {
        return this.isPlusInfinity() || this.isMinusInfinity();
    }

    public boolean isFinite() {
        return !this.isInfinite();
    }

    public boolean is(int n) {
        return this.number != null && this.number.equals(new BigDecimal(n));
    }

    public boolean isZero() {
        return this.sign == 0;
    }

    public boolean isNegative() {
        return this.sign == -1;
    }

    public boolean isPositive() {
        return this.sign == 1;
    }

    public boolean isNaN() {
        return this.number == null && this.sign == 3;
    }

    private static MathNumber cached(MathNumber i) {
        if (i.isZero()) {
            return ZERO;
        }
        if (i.is(1)) {
            return ONE;
        }
        if (i.is(-1)) {
            return MINUS_ONE;
        }
        return i;
    }

    public MathNumber add(MathNumber other) {
        if (this.isNaN() || other.isNaN()) {
            return NaN;
        }
        if (this.isInfinite()) {
            if (other.isFinite()) {
                return this;
            }
            if (this.equals(other)) {
                return this;
            }
            return NaN;
        }
        if (other.isInfinite()) {
            return other;
        }
        return MathNumber.cached(new MathNumber(this.number.add(other.number)));
    }

    public MathNumber subtract(MathNumber other) {
        if (this.isNaN() || other.isNaN()) {
            return NaN;
        }
        if (this.isInfinite()) {
            if (other.isFinite()) {
                return this;
            }
            if (this.equals(other)) {
                return NaN;
            }
            return this;
        }
        if (other.isInfinite()) {
            return other.multiply(MINUS_ONE);
        }
        return MathNumber.cached(new MathNumber(this.number.subtract(other.number)));
    }

    public MathNumber multiply(MathNumber other) {
        if (this.isNaN() || other.isNaN()) {
            return NaN;
        }
        if (this.isInfinite()) {
            if (other.isZero()) {
                return NaN;
            }
            if (this.sign == other.sign) {
                return PLUS_INFINITY;
            }
            return MINUS_INFINITY;
        }
        if (other.isInfinite()) {
            if (this.isZero()) {
                return NaN;
            }
            if (this.sign == other.sign) {
                return PLUS_INFINITY;
            }
            return MINUS_INFINITY;
        }
        if (this.isZero() || other.isZero()) {
            return ZERO;
        }
        return MathNumber.cached(new MathNumber(this.number.multiply(other.number)));
    }

    public MathNumber divide(MathNumber other) {
        if (this.isNaN() || other.isNaN() || other.isZero() || this.isInfinite() && other.isInfinite()) {
            return NaN;
        }
        if (this.isZero()) {
            return ZERO;
        }
        if (other.isPlusInfinity() || other.isMinusInfinity()) {
            return ZERO;
        }
        if (this.isPlusInfinity() || this.isMinusInfinity()) {
            if (this.isPositive() == other.isPositive()) {
                return PLUS_INFINITY;
            }
            return MINUS_INFINITY;
        }
        return MathNumber.cached(new MathNumber(this.number.divide(other.number, 100, RoundingMode.HALF_UP).stripTrailingZeros()));
    }

    @Override
    public int compareTo(MathNumber other) {
        if (this.equals(other)) {
            return 0;
        }
        if (this.isNaN() && !other.isNaN()) {
            return -1;
        }
        if (!this.isNaN() && other.isNaN()) {
            return 1;
        }
        if (this.isNaN()) {
            return 0;
        }
        int s = Byte.compare(this.sign, other.sign);
        if (s != 0) {
            return s;
        }
        if (this.isMinusInfinity() || other.isPlusInfinity()) {
            return -1;
        }
        if (this.isPlusInfinity() || other.isMinusInfinity()) {
            return 1;
        }
        return CollectionUtilities.nullSafeCompare(true, this.number, other.number, BigDecimal::compareTo);
    }

    public MathNumber min(MathNumber other) {
        if (this.isNaN() || other.isNaN()) {
            return NaN;
        }
        if (this.isMinusInfinity() || other.isPlusInfinity()) {
            return this;
        }
        if (other.isMinusInfinity() || this.isPlusInfinity()) {
            return other;
        }
        return MathNumber.cached(new MathNumber(this.number.min(other.number)));
    }

    public MathNumber max(MathNumber other) {
        if (this.isNaN() || other.isNaN()) {
            return NaN;
        }
        if (other.isMinusInfinity() || this.isPlusInfinity()) {
            return this;
        }
        if (this.isMinusInfinity() || other.isPlusInfinity()) {
            return other;
        }
        return MathNumber.cached(new MathNumber(this.number.max(other.number)));
    }

    public boolean leq(MathNumber other) {
        return this.max(other).equals(other);
    }

    public boolean gt(MathNumber other) {
        return this.geq(other) && !this.equals(other);
    }

    public boolean lt(MathNumber other) {
        return this.leq(other) && !this.equals(other);
    }

    public boolean geq(MathNumber other) {
        return this.max(other).equals(this);
    }

    public MathNumber abs() {
        if (this.isNaN()) {
            return NaN;
        }
        if (this.isPlusInfinity()) {
            return this;
        }
        if (this.isMinusInfinity()) {
            return PLUS_INFINITY;
        }
        return MathNumber.cached(new MathNumber(this.number.abs()));
    }

    public MathNumber roundUp() {
        if (this.isInfinite() || this.isNaN()) {
            return this;
        }
        return MathNumber.cached(new MathNumber(this.number.setScale(0, RoundingMode.CEILING)));
    }

    public MathNumber roundDown() {
        if (this.isInfinite() || this.isNaN()) {
            return this;
        }
        return MathNumber.cached(new MathNumber(this.number.setScale(0, RoundingMode.FLOOR)));
    }

    public int toInt() throws MathNumberConversionException {
        if (this.isNaN() || this.isInfinite()) {
            throw new MathNumberConversionException(this);
        }
        return this.number.intValue();
    }

    public double toDouble() throws MathNumberConversionException {
        if (this.isNaN() || this.isInfinite()) {
            throw new MathNumberConversionException(this);
        }
        return this.number.doubleValue();
    }

    public byte toByte() throws MathNumberConversionException {
        if (this.isNaN() || this.isInfinite()) {
            throw new MathNumberConversionException(this);
        }
        return this.number.byteValue();
    }

    public short toShort() throws MathNumberConversionException {
        if (this.isNaN() || this.isInfinite()) {
            throw new MathNumberConversionException(this);
        }
        return this.number.shortValue();
    }

    public float toFloat() throws MathNumberConversionException {
        if (this.isNaN() || this.isInfinite()) {
            throw new MathNumberConversionException(this);
        }
        return this.number.floatValue();
    }

    public long toLong() throws MathNumberConversionException {
        if (this.isNaN() || this.isInfinite()) {
            throw new MathNumberConversionException(this);
        }
        return this.number.longValue();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.number == null ? 0 : this.number.hashCode());
        result = 31 * result + this.sign;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MathNumber other = (MathNumber)obj;
        if (this.number == null ? other.number != null : !this.number.equals(other.number)) {
            return false;
        }
        return this.sign == other.sign;
    }

    public String toString() {
        return this.isNaN() ? "NaN" : (this.isMinusInfinity() ? "-Inf" : (this.isPlusInfinity() ? "+Inf" : this.number.toString()));
    }

    public BigDecimal getNumber() {
        if (this.isNaN()) {
            throw new IllegalStateException();
        }
        if (this.isPlusInfinity()) {
            throw new IllegalStateException();
        }
        if (this.isMinusInfinity()) {
            throw new IllegalStateException();
        }
        return this.number;
    }
}

