/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.util.numeric;

import it.unive.lisa.util.numeric.InfiniteIterationException;
import it.unive.lisa.util.numeric.IntIntervalIterator;
import it.unive.lisa.util.numeric.MathNumber;
import it.unive.lisa.util.numeric.MathNumberConversionException;
import java.util.Iterator;

public class IntInterval
implements Iterable<Long>,
Comparable<IntInterval> {
    public static final IntInterval INFINITY = new IntInterval();
    public static final IntInterval ZERO = new IntInterval(0, 0);
    public static final IntInterval ONE = new IntInterval(1, 1);
    public static final IntInterval MINUS_ONE = new IntInterval(-1, -1);
    private final MathNumber low;
    private final MathNumber high;

    private IntInterval() {
        this(MathNumber.MINUS_INFINITY, MathNumber.PLUS_INFINITY);
    }

    public IntInterval(int low, int high) {
        this(new MathNumber(low), new MathNumber(high));
    }

    public IntInterval(Integer low, Integer high) {
        this(low == null ? MathNumber.MINUS_INFINITY : new MathNumber(low.intValue()), high == null ? MathNumber.PLUS_INFINITY : new MathNumber(high.intValue()));
    }

    public IntInterval(MathNumber low, MathNumber high) {
        if (low.isNaN() || high.isNaN()) {
            this.low = MathNumber.NaN;
            this.high = MathNumber.NaN;
        } else if (low.compareTo(high) <= 0) {
            this.low = low;
            this.high = high;
        } else {
            this.low = high;
            this.high = low;
        }
    }

    public MathNumber getHigh() {
        return this.high;
    }

    public MathNumber getLow() {
        return this.low;
    }

    public boolean lowIsMinusInfinity() {
        return this.low.isMinusInfinity();
    }

    public boolean highIsPlusInfinity() {
        return this.high.isPlusInfinity();
    }

    public boolean isInfinite() {
        return this == INFINITY || this.highIsPlusInfinity() || this.lowIsMinusInfinity();
    }

    public boolean isFinite() {
        return !this.isInfinite();
    }

    public boolean isInfinity() {
        return this == INFINITY;
    }

    public boolean isSingleton() {
        return this.isFinite() && this.low.equals(this.high);
    }

    public boolean is(int n) {
        return this.isSingleton() && this.low.is(n);
    }

    private static IntInterval cacheAndRound(IntInterval i) {
        if (i.is(0)) {
            return ZERO;
        }
        if (i.is(1)) {
            return ONE;
        }
        if (i.is(-1)) {
            return MINUS_ONE;
        }
        return new IntInterval(i.low.roundDown(), i.high.roundUp());
    }

    public IntInterval plus(IntInterval other) {
        if (this.isInfinity() || other.isInfinity()) {
            return INFINITY;
        }
        return IntInterval.cacheAndRound(new IntInterval(this.low.add(other.low), this.high.add(other.high)));
    }

    public IntInterval diff(IntInterval other) {
        if (this.isInfinity() || other.isInfinity()) {
            return INFINITY;
        }
        return IntInterval.cacheAndRound(new IntInterval(this.low.subtract(other.high), this.high.subtract(other.low)));
    }

    private static MathNumber min(MathNumber ... nums) {
        if (nums.length == 0) {
            throw new IllegalArgumentException("No numbers provided");
        }
        MathNumber min = nums[0];
        for (int i = 1; i < nums.length; ++i) {
            min = min.min(nums[i]);
        }
        return min;
    }

    private static MathNumber max(MathNumber ... nums) {
        if (nums.length == 0) {
            throw new IllegalArgumentException("No numbers provided");
        }
        MathNumber max = nums[0];
        for (int i = 1; i < nums.length; ++i) {
            max = max.max(nums[i]);
        }
        return max;
    }

    public IntInterval mul(IntInterval other) {
        if (this.is(0) || other.is(0)) {
            return ZERO;
        }
        if (this.isInfinity() || other.isInfinity()) {
            return INFINITY;
        }
        if (this.low.compareTo(MathNumber.ZERO) >= 0 && other.low.compareTo(MathNumber.ZERO) >= 0) {
            return IntInterval.cacheAndRound(new IntInterval(this.low.multiply(other.low), this.high.multiply(other.high)));
        }
        MathNumber ll = this.low.multiply(other.low);
        MathNumber lh = this.low.multiply(other.high);
        MathNumber hl = this.high.multiply(other.low);
        MathNumber hh = this.high.multiply(other.high);
        return IntInterval.cacheAndRound(new IntInterval(IntInterval.min(ll, lh, hl, hh), IntInterval.max(ll, lh, hl, hh)));
    }

    public IntInterval div(IntInterval other, boolean ignoreZero, boolean errorOnZero) {
        IntInterval higher;
        if (errorOnZero && (other.is(0) || other.includes(ZERO))) {
            throw new ArithmeticException("IntInterval divide by zero");
        }
        if (this.is(0)) {
            return ZERO;
        }
        if (!other.includes(ZERO)) {
            return this.mul(new IntInterval(MathNumber.ONE.divide(other.high), MathNumber.ONE.divide(other.low)));
        }
        if (other.high.isZero()) {
            return this.mul(new IntInterval(MathNumber.MINUS_INFINITY, MathNumber.ONE.divide(other.low)));
        }
        if (other.low.isZero()) {
            return this.mul(new IntInterval(MathNumber.ONE.divide(other.high), MathNumber.PLUS_INFINITY));
        }
        if (ignoreZero) {
            return this.mul(new IntInterval(MathNumber.ONE.divide(other.low), MathNumber.ONE.divide(other.high)));
        }
        IntInterval lower = this.mul(new IntInterval(MathNumber.MINUS_INFINITY, MathNumber.ONE.divide(other.low)));
        if (lower.includes(higher = this.mul(new IntInterval(MathNumber.ONE.divide(other.high), MathNumber.PLUS_INFINITY)))) {
            return lower;
        }
        if (higher.includes(lower)) {
            return higher;
        }
        return IntInterval.cacheAndRound(new IntInterval(lower.low.compareTo(higher.low) > 0 ? higher.low : lower.low, lower.high.compareTo(higher.high) < 0 ? higher.high : lower.high));
    }

    public boolean includes(IntInterval other) {
        return this.low.compareTo(other.low) <= 0 && this.high.compareTo(other.high) >= 0;
    }

    public boolean intersects(IntInterval other) {
        return this.includes(other) || other.includes(this) || this.high.compareTo(other.low) >= 0 && this.high.compareTo(other.high) <= 0 || other.high.compareTo(this.low) >= 0 && other.high.compareTo(this.high) <= 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.high == null ? 0 : this.high.hashCode());
        result = 31 * result + (this.low == null ? 0 : this.low.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntInterval other = (IntInterval)obj;
        if (this.high == null ? other.high != null : !this.high.equals(other.high)) {
            return false;
        }
        return !(this.low == null ? other.low != null : !this.low.equals(other.low));
    }

    public String toString() {
        return "[" + this.low + ", " + this.high + "]";
    }

    @Override
    public Iterator<Long> iterator() {
        if (!this.low.isFinite() || !this.high.isFinite() || this.low.isNaN() || this.high.isNaN()) {
            throw new InfiniteIterationException(this);
        }
        try {
            return new IntIntervalIterator(this.low.toLong(), this.high.toLong());
        }
        catch (MathNumberConversionException e) {
            throw new InfiniteIterationException(this);
        }
    }

    @Override
    public int compareTo(IntInterval o) {
        int cmp = this.low.compareTo(o.low);
        if (cmp != 0) {
            return cmp;
        }
        return this.high.compareTo(o.high);
    }
}

