/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.util.file;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.TreeSet;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class FileManager {
    private final File workdir;
    private final Collection<String> createdFiles = new TreeSet<String>();
    private boolean usedPlainCytoscape = false;
    private boolean usedCompoundCytoscape = false;
    private static final int[] illegalChars = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 34, 42, 47, 58, 60, 62, 63, 92, 124};

    public FileManager(String workdir) {
        this.workdir = Paths.get(workdir, new String[0]).toFile();
    }

    public Collection<String> createdFiles() {
        return this.createdFiles;
    }

    public void usedCompoundCytoscape() {
        this.usedCompoundCytoscape = true;
    }

    public void usedPlainCytoscape() {
        this.usedPlainCytoscape = true;
    }

    public void mkOutputFile(String name, WriteAction filler) throws IOException {
        this.mkOutputFile(name, false, filler);
    }

    public void mkOutputFile(String path, String name, WriteAction filler) throws IOException {
        this.mkOutputFile(path, name, false, filler);
    }

    public void mkDotFile(String name, WriteAction filler) throws IOException {
        this.mkOutputFile(FileManager.cleanupCFGName(name) + ".dot", false, filler);
    }

    public void mkJsonFile(String name, WriteAction filler) throws IOException {
        this.mkOutputFile(FileManager.cleanupCFGName(name) + ".json", false, filler);
    }

    public void mkGraphmlFile(String name, WriteAction filler) throws IOException {
        this.mkOutputFile(FileManager.cleanupCFGName(name) + ".graphml", false, filler);
    }

    public void mkHtmlFile(String name, WriteAction filler) throws IOException {
        this.mkOutputFile(FileManager.cleanupCFGName(name) + ".html", false, filler);
    }

    public void mkOutputFile(String name, boolean bom, WriteAction filler) throws IOException {
        this.mkOutputFile(null, name, bom, filler);
    }

    public void mkOutputFile(String path, String name, boolean bom, WriteAction filler) throws IOException {
        File parent = this.workdir;
        if (path != null) {
            parent = new File(this.workdir, FileManager.cleanFileName(path, true));
        }
        File file = new File(parent, FileManager.cleanFileName(name, false));
        if (!parent.exists() && !parent.mkdirs()) {
            throw new IOException("Unable to create directory structure for " + file);
        }
        this.createdFiles.add(FilenameUtils.separatorsToUnix((String)this.workdir.toPath().relativize(file.toPath()).toString()));
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8.newEncoder());){
            if (bom) {
                ((Writer)writer).write(65279);
            }
            filler.perform(writer);
        }
    }

    private static String cleanFileName(String name, boolean keepDirSeparator) {
        StringBuilder cleanName = new StringBuilder();
        int len = name.codePointCount(0, name.length());
        for (int i = 0; i < len; ++i) {
            int c = name.codePointAt(i);
            if (keepDirSeparator && (c == 57 || c == 92) || Arrays.binarySearch(illegalChars, c) < 0) {
                cleanName.appendCodePoint(c);
                continue;
            }
            cleanName.appendCodePoint(95);
        }
        return cleanName.toString();
    }

    private static String cleanupCFGName(String name) {
        String result = name.replace(' ', '_');
        result = result.replace("::", ".");
        return result;
    }

    public static void forceDeleteFolder(String path) throws IOException {
        File workdir = new File(path);
        if (workdir.exists()) {
            FileUtils.forceDelete((File)workdir);
        }
    }

    public void generateSupportFiles() throws IOException {
        ArrayList<String> files = new ArrayList<String>();
        if (this.usedPlainCytoscape || this.usedCompoundCytoscape) {
            files.add("js/cytoscape-3.21.1.min.js");
            files.add("js/cytoscape-graphml-1.0.6-hier.js");
            files.add("js/jquery-3.0.0.min.js");
            if (this.usedCompoundCytoscape) {
                files.add("js/layout-base.js");
                files.add("js/cose-base.js");
                files.add("js/cytoscape-fcose.js");
                files.add("js/cytoscape-expand-collapse.js");
            }
        }
        for (String file : files) {
            InputStream stream = this.getClass().getClassLoader().getResourceAsStream("html-graph/" + file);
            try {
                String content = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
                int pos = file.lastIndexOf("/");
                if (pos == -1) {
                    this.mkOutputFile(file, false, (Writer writer) -> writer.write(content));
                    continue;
                }
                this.mkOutputFile(file.substring(0, pos), file.substring(pos + 1), false, writer -> writer.write(content));
            }
            finally {
                if (stream == null) continue;
                stream.close();
            }
        }
    }

    @FunctionalInterface
    public static interface WriteAction {
        public void perform(Writer var1) throws IOException;
    }
}

