/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.util.datastructures.regex.symbolic;

import it.unive.lisa.util.collections.IterableArray;
import it.unive.lisa.util.datastructures.regex.symbolic.SymbolicChar;
import it.unive.lisa.util.datastructures.regex.symbolic.UnknownSymbolicChar;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public final class SymbolicString
implements Comparable<SymbolicString>,
Iterable<SymbolicChar> {
    private final SymbolicChar[] value;

    public static SymbolicString mkEmptyString() {
        return new SymbolicString(new SymbolicChar[0]);
    }

    public static SymbolicString mkTopString(int length) {
        SymbolicChar[] value = new SymbolicChar[length];
        for (int i = 0; i < value.length; ++i) {
            value[i] = UnknownSymbolicChar.INSTANCE;
        }
        return new SymbolicString(value);
    }

    public static Set<String> toStrings(Iterable<SymbolicString> extStrings) {
        HashSet<String> result = new HashSet<String>();
        for (SymbolicString e : extStrings) {
            result.add(e.toString());
        }
        return result;
    }

    public static SymbolicString mkString(String str) {
        SymbolicChar[] value = new SymbolicChar[str.length()];
        for (int i = 0; i < value.length; ++i) {
            value[i] = new SymbolicChar(str.charAt(i));
        }
        return new SymbolicString(value);
    }

    public static SymbolicString[] mkStrings(String ... strings) {
        SymbolicString[] result = new SymbolicString[strings.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = SymbolicString.mkString(strings[i]);
        }
        return result;
    }

    public static SymbolicString mkStringFromChar(char ch) {
        return new SymbolicString(new SymbolicChar[]{new SymbolicChar(ch)});
    }

    private SymbolicString(SymbolicChar[] value) {
        this.value = value;
    }

    public String toString() {
        return StringUtils.join((Object[])this.value, (String)"");
    }

    @Override
    public int compareTo(SymbolicString other) {
        int lim = Math.min(this.length(), other.length());
        for (int k = 0; k < lim; ++k) {
            char c2;
            char c1 = this.value[k].asChar();
            if (c1 == (c2 = other.value[k].asChar())) continue;
            return c1 - c2;
        }
        return this.length() - other.length();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.value);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SymbolicString other = (SymbolicString)obj;
        return Arrays.equals(this.value, other.value);
    }

    public SymbolicString concat(SymbolicString str) {
        int olen = str.length();
        if (olen == 0) {
            return this;
        }
        SymbolicChar[] val = this.value;
        SymbolicChar[] oval = str.value;
        int len = val.length + oval.length;
        SymbolicChar[] buf = Arrays.copyOf(val, len);
        System.arraycopy(oval, 0, buf, val.length, oval.length);
        return new SymbolicString(buf);
    }

    public SymbolicString collapseTopChars() {
        ArrayList<SymbolicChar> chars = new ArrayList<SymbolicChar>();
        for (SymbolicChar ch : this.value) {
            chars.add(ch);
        }
        Iterator it = chars.iterator();
        SymbolicChar last = null;
        while (it.hasNext()) {
            SymbolicChar tmp = (SymbolicChar)it.next();
            if (tmp instanceof UnknownSymbolicChar) {
                if (last != null && last instanceof UnknownSymbolicChar) {
                    it.remove();
                    continue;
                }
                last = tmp;
                continue;
            }
            last = tmp;
        }
        return new SymbolicString(chars.toArray(new SymbolicChar[chars.size()]));
    }

    public int length() {
        return this.value.length;
    }

    private boolean startsWith(String prefix, int toffset) {
        if (toffset < 0 || toffset > this.length() - prefix.length()) {
            return false;
        }
        for (int i = 0; i < prefix.length(); ++i) {
            if (this.value[toffset + i].is(prefix.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(String prefix) {
        return this.startsWith(prefix, 0);
    }

    public boolean endsWith(String suffix) {
        return this.startsWith(suffix, this.length() - suffix.length());
    }

    private int indexOf(String str) {
        char first = str.charAt(0);
        int max = this.length() - str.length();
        for (int i = 0; i <= max; ++i) {
            if (!this.value[i].is(first)) {
                while (++i <= max && !this.value[i].is(first)) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + str.length() - 1;
            int k = 1;
            while (j < end && this.value[j].is(str.charAt(k))) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(CharSequence s) {
        return this.indexOf(s.toString()) >= 0;
    }

    @Override
    public Iterator<SymbolicChar> iterator() {
        return new IterableArray<SymbolicChar>(this.value).iterator();
    }
}

