/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.util.datastructures.regex;

import it.unive.lisa.util.datastructures.automaton.AutomataFactory;
import it.unive.lisa.util.datastructures.automaton.Automaton;
import it.unive.lisa.util.datastructures.automaton.TransitionSymbol;
import it.unive.lisa.util.datastructures.regex.Atom;
import it.unive.lisa.util.datastructures.regex.RegularExpression;
import it.unive.lisa.util.datastructures.regex.symbolic.SymbolicString;
import java.util.HashSet;
import java.util.Set;

public final class TopAtom
extends Atom {
    public static final String STRING = "\u0372";
    public static final TopAtom INSTANCE = new TopAtom();

    private TopAtom() {
        super(STRING);
    }

    @Override
    public <A extends Automaton<A, T>, T extends TransitionSymbol<T>> A toAutomaton(AutomataFactory<A, T> factory) {
        return factory.unknownString();
    }

    @Override
    protected Set<RegularExpression.PartialSubstring> substringAux(int charsToSkip, int missingChars) {
        int i;
        HashSet<RegularExpression.PartialSubstring> result = new HashSet<RegularExpression.PartialSubstring>();
        for (i = 0; i <= charsToSkip; ++i) {
            result.add(new RegularExpression.PartialSubstring(SymbolicString.mkEmptyString(), charsToSkip - i, missingChars));
        }
        for (i = 1; i <= missingChars; ++i) {
            result.add(new RegularExpression.PartialSubstring(SymbolicString.mkTopString(i), 0, missingChars - i));
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean is(String str) {
        return false;
    }

    @Override
    public int maxLength() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int minLength() {
        return 0;
    }

    @Override
    public boolean mayContain(String s) {
        return true;
    }

    @Override
    public boolean contains(String s) {
        return s.isEmpty();
    }

    @Override
    public boolean mayStartWith(String s) {
        return true;
    }

    @Override
    public boolean startsWith(String s) {
        return s.isEmpty();
    }

    @Override
    public boolean mayEndWith(String s) {
        return true;
    }

    @Override
    public boolean endsWith(String s) {
        return s.isEmpty();
    }

    @Override
    protected RegularExpression topAsSingleChar() {
        return new Atom(STRING){

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public boolean is(String str) {
                return false;
            }

            @Override
            public int maxLength() {
                return 1;
            }

            @Override
            public int minLength() {
                return 1;
            }

            @Override
            public boolean mayContain(String s) {
                return s.length() >= 1;
            }

            @Override
            public boolean contains(String s) {
                return s.isEmpty();
            }

            @Override
            public boolean mayStartWith(String s) {
                return s.length() >= 1;
            }

            @Override
            public boolean startsWith(String s) {
                return s.isEmpty();
            }

            @Override
            public boolean mayEndWith(String s) {
                return s.length() >= 1;
            }

            @Override
            public boolean endsWith(String s) {
                return s.isEmpty();
            }
        };
    }

    @Override
    protected RegularExpression topAsEmptyString() {
        return Atom.EPSILON;
    }

    @Override
    public RegularExpression reverse() {
        return this;
    }

    @Override
    public RegularExpression[] explode() {
        return new RegularExpression[]{this};
    }

    @Override
    protected int compareToAux(RegularExpression other) {
        return 0;
    }
}

