/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.util.datastructures.regex;

import it.unive.lisa.util.datastructures.automaton.AutomataFactory;
import it.unive.lisa.util.datastructures.automaton.Automaton;
import it.unive.lisa.util.datastructures.automaton.TransitionSymbol;
import it.unive.lisa.util.datastructures.regex.Atom;
import it.unive.lisa.util.datastructures.regex.Comp;
import it.unive.lisa.util.datastructures.regex.Or;
import it.unive.lisa.util.datastructures.regex.RegularExpression;
import it.unive.lisa.util.datastructures.regex.symbolic.SymbolicString;
import java.util.HashSet;
import java.util.Set;

public final class Star
extends RegularExpression {
    private final RegularExpression op;

    public Star(RegularExpression op) {
        this.op = op;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.op == null ? 0 : this.op.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Star other = (Star)obj;
        return !(this.op == null ? other.op != null : !this.op.equals(other.op));
    }

    public String toString() {
        if (this.op.isOr() || this.op.isAtom() && this.op.asAtom().getString().length() == 1) {
            return this.op.toString() + "*";
        }
        return "(" + this.op.toString() + ")*";
    }

    public RegularExpression getOperand() {
        return this.op;
    }

    @Override
    public RegularExpression simplify() {
        RegularExpression op = this.op.simplify();
        RegularExpression result = op.star();
        if (op.isAtom() && op.asAtom().isEmpty()) {
            result = Atom.EPSILON;
        } else if (op.isEmptySet()) {
            result = Atom.EPSILON;
        } else if (op.isStar()) {
            result = op;
        }
        return result;
    }

    @Override
    public <A extends Automaton<A, T>, T extends TransitionSymbol<T>> A toAutomaton(AutomataFactory<A, T> factory) {
        return ((Automaton)this.op.toAutomaton(factory)).star();
    }

    @Override
    public Set<RegularExpression.PartialSubstring> substringAux(int charsToSkip, int missingChars) {
        HashSet<RegularExpression.PartialSubstring> result = new HashSet<RegularExpression.PartialSubstring>();
        HashSet<RegularExpression.PartialSubstring> partial = new HashSet<RegularExpression.PartialSubstring>();
        result.add(new RegularExpression.PartialSubstring(SymbolicString.mkEmptyString(), charsToSkip, missingChars));
        do {
            if (!partial.isEmpty()) {
                result.addAll(partial);
                partial.clear();
            }
            for (RegularExpression.PartialSubstring base : result) {
                for (RegularExpression.PartialSubstring suffix : this.op.substringAux(base.getCharsToStart(), base.getMissingChars())) {
                    RegularExpression.PartialSubstring tmp = base.concat(suffix);
                    if (result.contains(tmp)) continue;
                    partial.add(tmp);
                }
            }
        } while (!partial.isEmpty());
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.op.isEmpty();
    }

    @Override
    public boolean is(String str) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int maxLength() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int minLength() {
        return 0;
    }

    @Override
    public boolean mayContain(String s) {
        if (s.isEmpty() || this.op.mayContain(s)) {
            return true;
        }
        int repetitions = s.length() / this.op.maxLength() + 2;
        Set<SymbolicString> substrings = this.substring(0, repetitions * this.op.maxLength() + 1);
        for (SymbolicString str : substrings) {
            if (!str.contains(s)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(String s) {
        return s.isEmpty();
    }

    @Override
    public boolean mayStartWith(String s) {
        if (s.isEmpty() || this.op.mayStartWith(s)) {
            return true;
        }
        int repetitions = s.length() / this.op.maxLength() + 2;
        Set<SymbolicString> substrings = this.substring(0, repetitions * this.op.maxLength() + 1);
        for (SymbolicString str : substrings) {
            if (!str.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean startsWith(String s) {
        return s.isEmpty();
    }

    @Override
    public boolean mayEndWith(String s) {
        if (s.isEmpty() || this.op.mayEndWith(s)) {
            return true;
        }
        int repetitions = s.length() / this.op.maxLength() + 2;
        Set<SymbolicString> substrings = this.substring(0, repetitions * this.op.maxLength() + 1);
        for (SymbolicString str : substrings) {
            if (!str.endsWith(s)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean endsWith(String s) {
        return s.isEmpty();
    }

    @Override
    protected RegularExpression unrollStarToFixedLength(int length) {
        if (length == 0) {
            return Atom.EPSILON;
        }
        RegularExpression result = null;
        for (int repetitions = length / this.op.maxLength() + 2; repetitions > 0; --repetitions) {
            result = result == null ? this.op : result.comp(this.op);
        }
        return result;
    }

    @Override
    public RegularExpression reverse() {
        return ((RegularExpression)this.op.reverse()).star();
    }

    @Override
    protected RegularExpression topAsEmptyString() {
        return this.op.topAsEmptyString().star();
    }

    @Override
    protected RegularExpression topAsSingleChar() {
        return this.op.topAsSingleChar().star();
    }

    @Override
    public RegularExpression[] explode() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int compareToAux(RegularExpression other) {
        return this.op.compareTo(other.asStar().op);
    }

    @Override
    public RegularExpression repeat(long n) {
        return this;
    }

    @Override
    public RegularExpression trimLeft() {
        RegularExpression trimLeft = this.op.trimLeft().simplify();
        if (trimLeft.isEmpty()) {
            return Atom.EPSILON;
        }
        return new Or(Atom.EPSILON, new Comp(trimLeft, this));
    }

    @Override
    public RegularExpression trimRight() {
        RegularExpression trimRight = this.op.trimRight();
        if (trimRight.isEmpty()) {
            return Atom.EPSILON;
        }
        return new Or(Atom.EPSILON, new Comp(this, trimRight));
    }

    @Override
    protected boolean readsWhiteSpaceString() {
        return this.op.readsWhiteSpaceString();
    }
}

