/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.util.datastructures.regex;

import it.unive.lisa.util.datastructures.automaton.AutomataFactory;
import it.unive.lisa.util.datastructures.automaton.Automaton;
import it.unive.lisa.util.datastructures.automaton.TransitionSymbol;
import it.unive.lisa.util.datastructures.regex.Atom;
import it.unive.lisa.util.datastructures.regex.Comp;
import it.unive.lisa.util.datastructures.regex.EmptySet;
import it.unive.lisa.util.datastructures.regex.Or;
import it.unive.lisa.util.datastructures.regex.Star;
import it.unive.lisa.util.datastructures.regex.symbolic.SymbolicString;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class RegularExpression
implements TransitionSymbol<RegularExpression> {
    @Override
    public final int compareTo(RegularExpression o) {
        if (this.getClass() != o.getClass()) {
            return this.getClass().getName().compareTo(o.getClass().getName());
        }
        return this.compareToAux(o);
    }

    protected abstract int compareToAux(RegularExpression var1);

    @Override
    public boolean isEpsilon() {
        return this == Atom.EPSILON || this.isAtom() && this.asAtom().isEmpty();
    }

    public abstract RegularExpression simplify();

    public abstract <A extends Automaton<A, T>, T extends TransitionSymbol<T>> A toAutomaton(AutomataFactory<A, T> var1);

    public final Atom asAtom() {
        return this.isAtom() ? (Atom)this : null;
    }

    public final boolean isAtom() {
        return this instanceof Atom;
    }

    public final Comp asComp() {
        return this.isComp() ? (Comp)this : null;
    }

    public final boolean isComp() {
        return this instanceof Comp;
    }

    public final EmptySet asEmptySet() {
        return this.isEmptySet() ? (EmptySet)this : null;
    }

    public final boolean isEmptySet() {
        return this instanceof EmptySet;
    }

    public final Or asOr() {
        return this.isOr() ? (Or)this : null;
    }

    public final boolean isOr() {
        return this instanceof Or;
    }

    public final Star asStar() {
        return this.isStar() ? (Star)this : null;
    }

    public final boolean isStar() {
        return this instanceof Star;
    }

    public final Set<SymbolicString> substring(int start, int end) {
        return this.substringAux(start, end - start).stream().filter(ps -> ps.missingChars == 0).map(t -> t.getSubstring()).collect(Collectors.toSet());
    }

    protected abstract Set<PartialSubstring> substringAux(int var1, int var2);

    public abstract RegularExpression repeat(long var1);

    public abstract RegularExpression trimLeft();

    public abstract RegularExpression trimRight();

    public abstract boolean isEmpty();

    public abstract boolean is(String var1);

    public abstract boolean mayContain(String var1);

    public abstract boolean contains(String var1);

    public abstract boolean mayStartWith(String var1);

    public abstract boolean startsWith(String var1);

    public abstract boolean mayEndWith(String var1);

    public abstract boolean endsWith(String var1);

    protected abstract RegularExpression unrollStarToFixedLength(int var1);

    protected abstract RegularExpression topAsSingleChar();

    protected abstract RegularExpression topAsEmptyString();

    public abstract RegularExpression[] explode();

    protected abstract boolean readsWhiteSpaceString();

    public final RegularExpression star() {
        if (this.isEpsilon()) {
            return this;
        }
        return new Star(this);
    }

    public final RegularExpression comp(RegularExpression other) {
        if (this.isEpsilon()) {
            return other;
        }
        if (other.isEpsilon()) {
            return this;
        }
        return new Comp(this, other);
    }

    public final RegularExpression or(RegularExpression other) {
        if (this.isEpsilon() && other.isEpsilon()) {
            return this;
        }
        return new Or(this, other);
    }

    public static final class PartialSubstring {
        private final SymbolicString substring;
        private final int missingChars;
        private final int charsToStart;

        protected PartialSubstring(SymbolicString substring, int charsToStart, int missingChars) {
            this.substring = substring;
            this.missingChars = missingChars;
            this.charsToStart = charsToStart;
        }

        protected PartialSubstring concat(PartialSubstring other) {
            return new PartialSubstring(this.substring.concat(other.substring), other.charsToStart, other.missingChars);
        }

        protected SymbolicString getSubstring() {
            return this.substring;
        }

        protected int getMissingChars() {
            return this.missingChars;
        }

        protected int getCharsToStart() {
            return this.charsToStart;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.charsToStart;
            result = 31 * result + this.missingChars;
            result = 31 * result + (this.substring == null ? 0 : this.substring.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PartialSubstring other = (PartialSubstring)obj;
            if (this.charsToStart != other.charsToStart) {
                return false;
            }
            if (this.missingChars != other.missingChars) {
                return false;
            }
            return !(this.substring == null ? other.substring != null : !this.substring.equals(other.substring));
        }

        public String toString() {
            return "\"" + this.substring + "\" [" + this.charsToStart + " to start, " + this.missingChars + " missing]";
        }
    }
}

