/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.util.datastructures.regex;

import it.unive.lisa.util.datastructures.automaton.AutomataFactory;
import it.unive.lisa.util.datastructures.automaton.Automaton;
import it.unive.lisa.util.datastructures.automaton.TransitionSymbol;
import it.unive.lisa.util.datastructures.regex.Atom;
import it.unive.lisa.util.datastructures.regex.RegularExpression;
import it.unive.lisa.util.datastructures.regex.Star;
import java.util.HashSet;
import java.util.Set;

public final class Or
extends RegularExpression {
    private final RegularExpression first;
    private final RegularExpression second;

    public Or(RegularExpression first, RegularExpression second) {
        if (first.compareTo(second) <= 0) {
            this.first = first;
            this.second = second;
        } else {
            this.first = second;
            this.second = first;
        }
    }

    public RegularExpression getSecond() {
        return this.second;
    }

    public RegularExpression getFirst() {
        return this.first;
    }

    public String toString() {
        return "(" + this.first.toString() + " + " + this.second.toString() + ")";
    }

    public boolean isAtomic() {
        return this.first.isAtom() && this.second.isAtom();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.first == null ? 0 : this.first.hashCode());
        result = 31 * result + (this.second == null ? 0 : this.second.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Or other = (Or)obj;
        if (this.first == null ? other.first != null : !this.first.equals(other.first)) {
            return false;
        }
        return !(this.second == null ? other.second != null : !this.second.equals(other.second));
    }

    @Override
    public RegularExpression simplify() {
        RegularExpression second;
        RegularExpression first = this.first.simplify();
        if (first.compareTo(second = this.second.simplify()) > 0) {
            RegularExpression tmp = first;
            first = second;
            second = tmp;
        }
        RegularExpression result = first.or(second);
        if (first.equals(second)) {
            return first;
        }
        if (first.isEmptySet()) {
            result = second;
        } else if (second.isEmptySet()) {
            result = first;
        } else if (first.isEpsilon() && second.isEpsilon()) {
            result = Atom.EPSILON;
        } else if (first.isEpsilon() && second.isStar()) {
            result = second;
        } else if (second.isEpsilon() && first.isStar()) {
            result = first;
        } else if (first.isEpsilon() && second.isComp() && second.asComp().getSecond().isStar() && second.asComp().getFirst().equals(second.asComp().getSecond().asStar().getOperand())) {
            result = second.asComp().getFirst().star();
        } else if (second.isEpsilon() && first.isComp() && first.asComp().getSecond().isStar() && first.asComp().getFirst().equals(first.asComp().getSecond().asStar().getOperand())) {
            result = first.asComp().getFirst().star();
        } else if (first.isEpsilon() && second.isComp() && second.asComp().getFirst().isStar() && second.asComp().getSecond().equals(second.asComp().getFirst().asStar().getOperand())) {
            result = second.asComp().getFirst().star();
        } else if (second.isEpsilon() && first.isComp() && first.asComp().getFirst().isStar() && first.asComp().getSecond().equals(first.asComp().getFirst().asStar().getOperand())) {
            result = first.asComp().getFirst().star();
        } else if (first.isComp() && first.asComp().getSecond().isStar() && first.asComp().getSecond().asStar().getOperand().isOr()) {
            Or or;
            RegularExpression a = first.asComp().getFirst();
            Star bORcSTAR = first.asComp().getSecond().asStar();
            RegularExpression b = bORcSTAR.getOperand().asOr().getFirst();
            RegularExpression c = bORcSTAR.getOperand().asOr().getSecond();
            if (second.isComp() && second.asComp().getFirst().equals(a) && second.asComp().getSecond().isComp() && second.asComp().getSecond().asComp().getSecond().equals(bORcSTAR) && second.asComp().getSecond().asComp().getFirst().isOr() && (or = second.asComp().getSecond().asComp().getFirst().asOr()).getFirst().isComp() && or.getFirst().asComp().getFirst().equals(bORcSTAR) && or.getFirst().asComp().getSecond().equals(b) && or.getSecond().isComp() && or.getSecond().asComp().getFirst().equals(bORcSTAR) && or.getSecond().asComp().getSecond().equals(c)) {
                result = first;
            }
        }
        return result;
    }

    @Override
    public <A extends Automaton<A, T>, T extends TransitionSymbol<T>> A toAutomaton(AutomataFactory<A, T> factory) {
        return ((Automaton)this.first.toAutomaton(factory)).union(this.second.toAutomaton(factory));
    }

    @Override
    protected Set<RegularExpression.PartialSubstring> substringAux(int charsToSkip, int missingChars) {
        HashSet<RegularExpression.PartialSubstring> result = new HashSet<RegularExpression.PartialSubstring>();
        result.addAll(this.first.substringAux(charsToSkip, missingChars));
        result.addAll(this.second.substringAux(charsToSkip, missingChars));
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.first.isEmpty() && this.second.isEmpty();
    }

    @Override
    public boolean is(String str) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int maxLength() {
        return Math.max(this.first.maxLength(), this.second.maxLength());
    }

    @Override
    public int minLength() {
        return Math.min(this.first.minLength(), this.second.minLength());
    }

    @Override
    public boolean mayContain(String s) {
        return this.first.mayContain(s) || this.second.mayContain(s);
    }

    @Override
    public boolean contains(String s) {
        return this.first.contains(s) && this.second.contains(s);
    }

    @Override
    public boolean mayStartWith(String s) {
        return this.first.mayStartWith(s) || this.second.mayEndWith(s);
    }

    @Override
    public boolean startsWith(String s) {
        return this.first.startsWith(s) && this.second.startsWith(s);
    }

    @Override
    public boolean mayEndWith(String s) {
        return this.first.mayEndWith(s) || this.second.mayEndWith(s);
    }

    @Override
    public boolean endsWith(String s) {
        return this.first.endsWith(s) && this.second.endsWith(s);
    }

    @Override
    protected RegularExpression unrollStarToFixedLength(int length) {
        return this.first.unrollStarToFixedLength(length).or(this.second.unrollStarToFixedLength(length));
    }

    @Override
    public RegularExpression reverse() {
        return ((RegularExpression)this.first.reverse()).or((RegularExpression)this.second.reverse());
    }

    @Override
    protected RegularExpression topAsEmptyString() {
        return this.first.topAsEmptyString().or(this.second.topAsEmptyString());
    }

    @Override
    protected RegularExpression topAsSingleChar() {
        return this.first.topAsSingleChar().or(this.second.topAsSingleChar());
    }

    @Override
    public RegularExpression[] explode() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int compareToAux(RegularExpression other) {
        int cmp = this.first.compareTo(other.asOr().first);
        if (cmp != 0) {
            return cmp;
        }
        return this.second.compareTo(other.asOr().second);
    }

    @Override
    public RegularExpression repeat(long n) {
        return new Or(this.first.repeat(n), this.second.repeat(n)).simplify();
    }

    @Override
    public RegularExpression trimLeft() {
        return new Or(this.first.trimLeft(), this.second.trimLeft());
    }

    @Override
    public RegularExpression trimRight() {
        return new Or(this.first.trimRight(), this.second.trimRight());
    }

    @Override
    protected boolean readsWhiteSpaceString() {
        return this.first.readsWhiteSpaceString() || this.second.readsWhiteSpaceString();
    }
}

