/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.util.datastructures.regex;

import it.unive.lisa.util.datastructures.automaton.AutomataFactory;
import it.unive.lisa.util.datastructures.automaton.Automaton;
import it.unive.lisa.util.datastructures.automaton.TransitionSymbol;
import it.unive.lisa.util.datastructures.regex.Atom;
import it.unive.lisa.util.datastructures.regex.EmptySet;
import it.unive.lisa.util.datastructures.regex.Or;
import it.unive.lisa.util.datastructures.regex.RegularExpression;
import it.unive.lisa.util.datastructures.regex.Star;
import it.unive.lisa.util.datastructures.regex.symbolic.SymbolicString;
import java.util.HashSet;
import java.util.Set;

public final class Comp
extends RegularExpression {
    private final RegularExpression first;
    private final RegularExpression second;

    public Comp(RegularExpression first, RegularExpression second) {
        this.first = first;
        this.second = second;
    }

    public RegularExpression getFirst() {
        return this.first;
    }

    public RegularExpression getSecond() {
        return this.second;
    }

    public String toString() {
        return this.first.toString() + this.second.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.first == null ? 0 : this.first.hashCode());
        result = 31 * result + (this.second == null ? 0 : this.second.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Comp other = (Comp)obj;
        if (this.first == null ? other.first != null : !this.first.equals(other.first)) {
            return false;
        }
        return !(this.second == null ? other.second != null : !this.second.equals(other.second));
    }

    @Override
    public RegularExpression simplify() {
        RegularExpression first = this.first.simplify();
        RegularExpression second = this.second.simplify();
        RegularExpression result = first.comp(second);
        if (first.isEmptySet() || second.isEmptySet()) {
            result = EmptySet.INSTANCE;
        } else if (first.isAtom() && second.isOr() && second.asOr().isAtomic()) {
            result = first.comp(second.asOr().getFirst()).or(first.comp(second.asOr().getSecond()));
        } else if (second.isEpsilon()) {
            result = first;
        } else if (first.isEpsilon()) {
            result = second;
        } else if (first.isStar() && second.isStar() && second.asStar().getOperand().isComp() && second.asStar().getOperand().asComp().second.isStar() && second.asStar().getOperand().asComp().second.asStar().getOperand().equals(first.asStar().getOperand())) {
            result = first.asStar().getOperand().or(second.asStar().getOperand().asComp().first).star();
        } else if (first.isAtom() && second.isComp() && second.asComp().first.isStar() && second.asComp().second.isAtom() && second.asComp().second.asAtom().comp(first.asAtom()).equals(second.asComp().first.asStar().getOperand())) {
            result = first.asAtom().comp(second.asComp().second.asAtom()).star();
        } else if (first.isStar() && second.isComp() && second.asComp().first.isStar() && first.asStar().getOperand().equals(second.asComp().first.asStar().getOperand())) {
            result = first.comp(second.asComp().second);
        } else if (first instanceof Star && second instanceof Star && first.asStar().getOperand().equals(second.asStar().getOperand())) {
            result = first;
        }
        return result;
    }

    @Override
    public <A extends Automaton<A, T>, T extends TransitionSymbol<T>> A toAutomaton(AutomataFactory<A, T> factory) {
        return ((Automaton)this.first.toAutomaton(factory)).concat(this.second.toAutomaton(factory));
    }

    @Override
    protected Set<RegularExpression.PartialSubstring> substringAux(int charsToSkip, int missingChars) {
        HashSet<RegularExpression.PartialSubstring> result = new HashSet<RegularExpression.PartialSubstring>();
        Set<RegularExpression.PartialSubstring> firstSS = this.first.substringAux(charsToSkip, missingChars);
        for (RegularExpression.PartialSubstring s : firstSS) {
            if (s.getMissingChars() == 0) {
                result.add(s);
                continue;
            }
            Set<RegularExpression.PartialSubstring> secondSS = this.second.substringAux(s.getCharsToStart(), s.getMissingChars());
            for (RegularExpression.PartialSubstring ss : secondSS) {
                result.add(s.concat(ss));
            }
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.first.isEmpty() && this.second.isEmpty();
    }

    @Override
    public boolean is(String str) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int maxLength() {
        int second;
        int first = this.first.maxLength();
        if (first == Integer.MAX_VALUE || (second = this.second.maxLength()) == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return first + second;
    }

    @Override
    public int minLength() {
        return this.first.minLength() + this.second.minLength();
    }

    @Override
    public boolean mayContain(String s) {
        if (this.first.mayContain(s) || this.second.mayContain(s)) {
            return true;
        }
        RegularExpression tmp = this.topAsEmptyString().unrollStarToFixedLength(s.length());
        Set<SymbolicString> substrings = tmp.substring(0, tmp.maxLength());
        for (SymbolicString str : substrings) {
            if (!str.contains(s)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(String s) {
        if (this.first.contains(s) || this.second.contains(s)) {
            return true;
        }
        RegularExpression tmp = this.topAsSingleChar().unrollStarToFixedLength(0);
        Set<SymbolicString> substrings = tmp.substring(0, tmp.maxLength());
        for (SymbolicString str : substrings) {
            if (str.contains(s)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean mayStartWith(String s) {
        if (this.first.mayStartWith(s)) {
            return true;
        }
        Set<SymbolicString> substrings = this.substring(0, s.length());
        for (SymbolicString str : substrings) {
            if (!str.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean startsWith(String s) {
        if (this.first.startsWith(s)) {
            return true;
        }
        Set<SymbolicString> substrings = this.substring(0, s.length());
        for (SymbolicString str : substrings) {
            if (str.startsWith(s)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean mayEndWith(String s) {
        if (this.second.mayEndWith(s)) {
            return true;
        }
        return this.reverse().mayStartWith(new StringBuilder(s).reverse().toString());
    }

    @Override
    public boolean endsWith(String s) {
        if (this.second.endsWith(s)) {
            return true;
        }
        return this.reverse().startsWith(new StringBuilder(s).reverse().toString());
    }

    @Override
    protected RegularExpression unrollStarToFixedLength(int length) {
        return this.first.unrollStarToFixedLength(length).comp(this.second.unrollStarToFixedLength(length));
    }

    @Override
    public RegularExpression reverse() {
        return ((RegularExpression)this.second.reverse()).comp((RegularExpression)this.first.reverse());
    }

    @Override
    protected RegularExpression topAsEmptyString() {
        return this.first.topAsEmptyString().comp(this.second.topAsEmptyString());
    }

    @Override
    protected RegularExpression topAsSingleChar() {
        return this.first.topAsSingleChar().comp(this.second.topAsSingleChar());
    }

    @Override
    public RegularExpression[] explode() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int compareToAux(RegularExpression other) {
        int cmp = this.first.compareTo(other.asComp().first);
        if (cmp != 0) {
            return cmp;
        }
        return this.second.compareTo(other.asComp().second);
    }

    @Override
    public RegularExpression repeat(long n) {
        if (n == 0L) {
            return Atom.EPSILON;
        }
        RegularExpression r = Atom.EPSILON;
        for (long i = 0L; i < n; ++i) {
            r = new Comp(r, this);
        }
        return ((RegularExpression)r).simplify();
    }

    @Override
    public RegularExpression trimLeft() {
        RegularExpression trimLeftFirst = this.first.trimLeft().simplify();
        if (trimLeftFirst.isEmpty()) {
            return this.second.trimLeft();
        }
        if (this.first.readsWhiteSpaceString()) {
            return new Or(new Comp(trimLeftFirst, this.second), this.second.trimLeft());
        }
        return new Comp(trimLeftFirst, this.second);
    }

    @Override
    public RegularExpression trimRight() {
        RegularExpression trimRightSecond = this.second.trimRight().simplify();
        if (trimRightSecond.isEmpty()) {
            return this.first.trimRight();
        }
        if (this.second.readsWhiteSpaceString()) {
            return new Or(new Comp(this.first, trimRightSecond), this.first.trimRight());
        }
        return new Comp(this.first, trimRightSecond);
    }

    @Override
    protected boolean readsWhiteSpaceString() {
        return this.first.readsWhiteSpaceString() && this.second.readsWhiteSpaceString();
    }
}

