/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.util.datastructures.regex;

import it.unive.lisa.util.datastructures.automaton.AutomataFactory;
import it.unive.lisa.util.datastructures.automaton.Automaton;
import it.unive.lisa.util.datastructures.automaton.TransitionSymbol;
import it.unive.lisa.util.datastructures.regex.Comp;
import it.unive.lisa.util.datastructures.regex.RegularExpression;
import it.unive.lisa.util.datastructures.regex.symbolic.SymbolicString;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class Atom
extends RegularExpression {
    public static final Atom EPSILON = new Atom("");
    private final String string;

    public Atom(String s) {
        this.string = s;
    }

    public String getString() {
        return this.string;
    }

    public String toString() {
        return this == EPSILON || this.string.isEmpty() ? "\u03b5" : this.string;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.string == null ? 0 : this.string.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Atom other = (Atom)obj;
        return !(this.string == null ? other.string != null : !this.string.equals(other.string));
    }

    @Override
    public RegularExpression simplify() {
        return this;
    }

    @Override
    public <A extends Automaton<A, T>, T extends TransitionSymbol<T>> A toAutomaton(AutomataFactory<A, T> factory) {
        return this.isEmpty() ? factory.emptyString() : factory.singleString(this.string);
    }

    @Override
    protected Set<RegularExpression.PartialSubstring> substringAux(int charsToSkip, int missingChars) {
        HashSet<RegularExpression.PartialSubstring> result = new HashSet<RegularExpression.PartialSubstring>();
        int len = this.string.length();
        if (charsToSkip > len) {
            result.add(new RegularExpression.PartialSubstring(SymbolicString.mkEmptyString(), charsToSkip - len, missingChars));
        } else if (charsToSkip + missingChars > len) {
            result.add(new RegularExpression.PartialSubstring(SymbolicString.mkString(this.string.substring(charsToSkip)), 0, missingChars - len + charsToSkip));
        } else {
            result.add(new RegularExpression.PartialSubstring(SymbolicString.mkString(this.string.substring(charsToSkip, charsToSkip + missingChars)), 0, 0));
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.string.isEmpty();
    }

    @Override
    public boolean is(String str) {
        return this.string.equals(str);
    }

    @Override
    public int maxLength() {
        return this.string.length();
    }

    @Override
    public int minLength() {
        return this.maxLength();
    }

    @Override
    public boolean mayContain(String s) {
        return this.contains(s);
    }

    @Override
    public boolean contains(String s) {
        return this.string.contains(s);
    }

    @Override
    public boolean mayStartWith(String s) {
        return this.startsWith(s);
    }

    @Override
    public boolean startsWith(String s) {
        return this.string.startsWith(s);
    }

    @Override
    public boolean mayEndWith(String s) {
        return this.endsWith(s);
    }

    @Override
    public boolean endsWith(String s) {
        return this.string.endsWith(s);
    }

    @Override
    protected RegularExpression unrollStarToFixedLength(int length) {
        return this;
    }

    @Override
    public RegularExpression reverse() {
        return new Atom(new StringBuilder(this.string).reverse().toString());
    }

    @Override
    protected RegularExpression topAsEmptyString() {
        return this;
    }

    @Override
    protected RegularExpression topAsSingleChar() {
        return this;
    }

    @Override
    public RegularExpression[] explode() {
        return (RegularExpression[])this.string.chars().mapToObj(ch -> String.valueOf((char)ch)).map(Atom::new).toArray(RegularExpression[]::new);
    }

    @Override
    protected int compareToAux(RegularExpression other) {
        return this.string.compareTo(other.asAtom().string);
    }

    @Override
    public RegularExpression repeat(long n) {
        if (n == 0L) {
            return EPSILON;
        }
        RegularExpression r = EPSILON;
        for (long i = 0L; i < n; ++i) {
            r = new Comp(r, this);
        }
        ((RegularExpression)r).simplify();
        return r;
    }

    @Override
    public RegularExpression trimLeft() {
        String trimLeft = StringUtils.stripStart((String)this.string, null);
        if (trimLeft.isEmpty()) {
            return EPSILON;
        }
        return new Atom(trimLeft);
    }

    @Override
    public RegularExpression trimRight() {
        String trimRight = StringUtils.stripEnd((String)this.string, null);
        if (trimRight.isEmpty()) {
            return EPSILON;
        }
        return new Atom(trimRight);
    }

    @Override
    protected boolean readsWhiteSpaceString() {
        return this.string.trim().isEmpty();
    }
}

