/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.util.datastructures.graph.code;

import it.unive.lisa.program.ProgramValidationException;
import it.unive.lisa.util.collections.CollectionUtilities;
import it.unive.lisa.util.datastructures.graph.Edge;
import it.unive.lisa.util.datastructures.graph.code.CodeEdge;
import it.unive.lisa.util.datastructures.graph.code.CodeGraph;
import it.unive.lisa.util.datastructures.graph.code.CodeNode;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class NodeList<G extends CodeGraph<G, N, E>, N extends CodeNode<G, N, E>, E extends CodeEdge<G, N, E>>
implements Iterable<N> {
    private static final String EDGE_SIMPLIFY_ERROR = "Cannot simplify an edge with class ";
    private final List<N> nodes;
    private final Set<Integer> cutoff;
    private final Map<N, NodeEdges<G, N, E>> extraEdges;
    private final E sequentialSingleton;

    public NodeList(E sequentialSingleton) {
        this(sequentialSingleton, true);
    }

    public NodeList(E sequentialSingleton, boolean computeOffsets) {
        this.sequentialSingleton = sequentialSingleton;
        this.nodes = new LinkedList<N>();
        this.cutoff = new HashSet<Integer>();
        this.extraEdges = new HashMap<N, NodeEdges<G, N, E>>();
    }

    public NodeList(NodeList<G, N, E> other) {
        this.sequentialSingleton = other.sequentialSingleton;
        this.nodes = new LinkedList<N>(other.nodes);
        this.cutoff = new HashSet<Integer>(other.cutoff);
        this.extraEdges = new HashMap<N, NodeEdges<G, N, E>>();
        for (Map.Entry<N, NodeEdges<G, N, E>> entry : other.extraEdges.entrySet()) {
            this.extraEdges.put((CodeNode)entry.getKey(), new NodeEdges<G, N, E>(entry.getValue()));
        }
    }

    public void addNode(N node) {
        if (this.containsNode(node)) {
            return;
        }
        int size = this.nodes.size();
        if (size != 0) {
            this.cutoff.add(size - 1);
        }
        this.nodes.add(node);
    }

    public void removeNode(N node) {
        if (!this.containsNode(node)) {
            return;
        }
        int target = this.nodes.indexOf(node);
        NodeEdges<G, N, E> edges = this.extraEdges.get(node);
        if (edges != null) {
            HashSet union = new HashSet(edges.ingoing);
            union.addAll(edges.outgoing);
            union.forEach(this::removeEdge);
            this.cutoff.remove(target);
        }
        this.nodes.remove(node);
        List<Integer> interesting = this.cutoff.stream().filter(i -> i >= target).sorted().collect(Collectors.toList());
        this.cutoff.removeAll(interesting);
        interesting.forEach(i -> this.cutoff.add(i - 1));
        if (target != 0 && target != this.nodes.size()) {
            CodeNode pred = (CodeNode)this.nodes.get(target - 1);
            CodeNode succ = (CodeNode)this.nodes.get(target);
            NodeEdges<G, N, E> predEdges = this.extraEdges.get(pred);
            if (predEdges != null) {
                Object seq = this.sequentialSingleton.newInstance((CodeNode)pred, (CodeNode)succ);
                if (predEdges.outgoing.contains(seq)) {
                    this.removeEdge(seq);
                    this.cutoff.remove(target - 1);
                } else {
                    this.cutoff.add(target - 1);
                }
            } else {
                this.cutoff.add(target - 1);
            }
        }
    }

    public final Collection<N> getNodes() {
        return new ArrayList<N>(this.nodes);
    }

    public void addEdge(E e) {
        int src = this.nodes.indexOf(e.getSource());
        if (src == -1) {
            throw new UnsupportedOperationException("The source node is not in the graph");
        }
        int dest = this.nodes.indexOf(e.getDestination());
        if (dest == -1) {
            throw new UnsupportedOperationException("The destination node is not in the graph");
        }
        if (e.isUnconditional() && src == dest - 1) {
            this.cutoff.remove(src);
        } else {
            this.extraEdges.computeIfAbsent((CodeNode)e.getSource(), (Function<CodeNode, NodeEdges>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$addEdge$2(it.unive.lisa.util.datastructures.graph.code.CodeNode ), (Lit/unive/lisa/util/datastructures/graph/code/CodeNode;)Lit/unive/lisa/util/datastructures/graph/code/NodeList$NodeEdges;)()).outgoing.add(e);
            this.extraEdges.computeIfAbsent((CodeNode)e.getDestination(), (Function<CodeNode, NodeEdges>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$addEdge$3(it.unive.lisa.util.datastructures.graph.code.CodeNode ), (Lit/unive/lisa/util/datastructures/graph/code/CodeNode;)Lit/unive/lisa/util/datastructures/graph/code/NodeList$NodeEdges;)()).ingoing.add(e);
        }
    }

    public void removeEdge(E e) {
        NodeEdges<G, N, E> edges;
        int src = this.nodes.indexOf(e.getSource());
        int dest = this.nodes.indexOf(e.getDestination());
        if (src == -1 || dest == -1) {
            return;
        }
        if (e.isUnconditional() && src == dest - 1) {
            this.cutoff.add(src);
        }
        if ((edges = this.extraEdges.get(e.getSource())) != null) {
            edges.outgoing.remove(e);
            if (edges.ingoing.isEmpty() && edges.outgoing.isEmpty()) {
                this.extraEdges.remove(e.getSource());
            }
        }
        if ((edges = this.extraEdges.get(e.getDestination())) != null) {
            edges.ingoing.remove(e);
            if (edges.ingoing.isEmpty() && edges.outgoing.isEmpty()) {
                this.extraEdges.remove(e.getDestination());
            }
        }
    }

    public final E getEdgeConnecting(N source, N destination) {
        int src = this.nodes.indexOf(source);
        int dest = this.nodes.indexOf(destination);
        if (src == -1 || dest == -1) {
            return null;
        }
        if (src == dest - 1 && !this.cutoff.contains(src)) {
            return this.sequentialSingleton.newInstance(source, destination);
        }
        NodeEdges<G, N, E> edges = this.extraEdges.get(source);
        if (edges == null) {
            return null;
        }
        for (CodeEdge e : edges.outgoing) {
            if (!((CodeNode)e.getDestination()).equals(destination)) continue;
            return (E)e;
        }
        return null;
    }

    public Collection<E> getEdgesConnecting(N source, N destination) {
        NodeEdges<G, N, E> edges;
        int src = this.nodes.indexOf(source);
        int dest = this.nodes.indexOf(destination);
        if (src == -1 || dest == -1) {
            return Collections.emptySet();
        }
        HashSet result = new HashSet();
        if (src == dest - 1 && !this.cutoff.contains(src)) {
            result.add(this.sequentialSingleton.newInstance(source, destination));
        }
        if ((edges = this.extraEdges.get(source)) != null) {
            for (CodeEdge e : edges.outgoing) {
                if (!((CodeNode)e.getDestination()).equals(destination)) continue;
                result.add(e);
            }
        }
        return result.isEmpty() ? Collections.emptySet() : result;
    }

    public final Collection<E> getIngoingEdges(N node) {
        NodeEdges<G, N, E> edges;
        int src = this.nodes.indexOf(node);
        if (src == -1) {
            return Collections.emptySet();
        }
        HashSet result = new HashSet();
        if (src != 0 && !this.cutoff.contains(src - 1)) {
            result.add(this.sequentialSingleton.newInstance((CodeNode)((CodeNode)this.nodes.get(src - 1)), node));
        }
        if ((edges = this.extraEdges.get(node)) != null) {
            result.addAll(edges.ingoing);
        }
        return result.isEmpty() ? Collections.emptySet() : result;
    }

    public final Collection<E> getOutgoingEdges(N node) {
        NodeEdges<G, N, E> edges;
        int src = this.nodes.indexOf(node);
        if (src == -1) {
            return Collections.emptySet();
        }
        HashSet result = new HashSet();
        if (src != this.nodes.size() - 1 && !this.cutoff.contains(src)) {
            result.add(this.sequentialSingleton.newInstance(node, (CodeNode)((CodeNode)this.nodes.get(src + 1))));
        }
        if ((edges = this.extraEdges.get(node)) != null) {
            result.addAll(edges.outgoing);
        }
        return result.isEmpty() ? Collections.emptySet() : result;
    }

    public final Collection<E> getEdges() {
        Set result = this.extraEdges.values().stream().flatMap(c -> Stream.concat(c.ingoing.stream(), c.outgoing.stream())).distinct().collect(Collectors.toSet());
        for (int i = 0; i < this.nodes.size() - 1; ++i) {
            if (this.cutoff.contains(i)) continue;
            result.add(this.sequentialSingleton.newInstance((CodeNode)((CodeNode)this.nodes.get(i)), (CodeNode)((CodeNode)this.nodes.get(i + 1))));
        }
        return result;
    }

    public final Collection<N> followersOf(N node) {
        NodeEdges<G, N, E> edges;
        int src = this.nodes.indexOf(node);
        if (src == -1) {
            throw new IllegalArgumentException("'" + node + "' is not in the graph");
        }
        HashSet result = new HashSet();
        if (src != this.nodes.size() - 1 && !this.cutoff.contains(src)) {
            result.add((CodeNode)this.nodes.get(src + 1));
        }
        if ((edges = this.extraEdges.get(node)) != null) {
            result.addAll(edges.outgoing.stream().map(Edge::getDestination).collect(Collectors.toSet()));
        }
        return result.isEmpty() ? Collections.emptySet() : result;
    }

    public final Collection<N> predecessorsOf(N node) {
        NodeEdges<G, N, E> edges;
        int src = this.nodes.indexOf(node);
        if (src == -1) {
            throw new IllegalArgumentException("'" + node + "' is not in the graph");
        }
        HashSet result = new HashSet();
        if (src != 0 && !this.cutoff.contains(src - 1)) {
            result.add((CodeNode)this.nodes.get(src - 1));
        }
        if ((edges = this.extraEdges.get(node)) != null) {
            result.addAll(edges.ingoing.stream().map(Edge::getSource).collect(Collectors.toSet()));
        }
        return result.isEmpty() ? Collections.emptySet() : result;
    }

    public void simplify(Iterable<N> targets, Collection<N> entrypoints, Collection<E> removedEdges, Map<Pair<E, E>, E> replacedEdges) {
        removedEdges.clear();
        replacedEdges.clear();
        for (CodeNode t : targets) {
            boolean entry = entrypoints.contains(t);
            Collection<E> ingoing = this.getIngoingEdges(t);
            Collection<E> outgoing = this.getOutgoingEdges(t);
            if (ingoing.isEmpty() && !outgoing.isEmpty()) {
                for (CodeEdge out : outgoing) {
                    if (!out.isUnconditional()) {
                        throw new UnsupportedOperationException(EDGE_SIMPLIFY_ERROR + out.getClass().getSimpleName());
                    }
                    removedEdges.add(out);
                    if (!entry) continue;
                    entrypoints.add((CodeNode)out.getDestination());
                }
            } else if (!ingoing.isEmpty() && outgoing.isEmpty()) {
                for (CodeEdge in : ingoing) {
                    if (!in.isUnconditional()) {
                        throw new UnsupportedOperationException(EDGE_SIMPLIFY_ERROR + in.getClass().getSimpleName());
                    }
                    removedEdges.add(in);
                }
            } else {
                for (CodeEdge in : ingoing) {
                    for (CodeEdge out : outgoing) {
                        if (!out.isUnconditional()) {
                            throw new UnsupportedOperationException(EDGE_SIMPLIFY_ERROR + out.getClass().getSimpleName());
                        }
                        Object _new = in.newInstance((CodeNode)in.getSource(), (CodeNode)out.getDestination());
                        replacedEdges.put(Pair.of((Object)in, (Object)out), _new);
                        this.addEdge(_new);
                    }
                }
            }
            if (entry) {
                entrypoints.remove(t);
            }
            this.removeNode(t);
        }
    }

    public boolean containsNode(N node) {
        return this.nodes.contains(node);
    }

    public boolean containsEdge(E edge) {
        int src = this.nodes.indexOf(edge.getSource());
        int dest = this.nodes.indexOf(edge.getDestination());
        if (src == -1 || dest == -1) {
            return false;
        }
        if (src == dest - 1 && !this.cutoff.contains(src) && edge.isUnconditional() && this.sequentialSingleton.newInstance((CodeNode)((CodeNode)edge.getSource()), (CodeNode)((CodeNode)edge.getDestination())).equals(edge)) {
            return true;
        }
        NodeEdges<G, N, E> edges = this.extraEdges.get(edge.getSource());
        if (edges == null) {
            return false;
        }
        return edges.outgoing.contains(edge);
    }

    @Override
    public Iterator<N> iterator() {
        return this.getNodes().iterator();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cutoff == null ? 0 : this.cutoff.hashCode());
        result = 31 * result + (this.extraEdges == null ? 0 : this.extraEdges.hashCode());
        result = 31 * result + (this.nodes == null ? 0 : this.nodes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodeList other = (NodeList)obj;
        if (this.cutoff == null ? other.cutoff != null : !this.cutoff.equals(other.cutoff)) {
            return false;
        }
        if (this.extraEdges == null ? other.extraEdges != null : !this.extraEdges.equals(other.extraEdges)) {
            return false;
        }
        return !(this.nodes == null ? other.nodes != null : !this.nodes.equals(other.nodes));
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < this.nodes.size(); ++i) {
            CodeNode node = (CodeNode)this.nodes.get(i);
            res.append(node);
            NodeEdges<G, N, E> edges = this.extraEdges.get(node);
            if (edges != null) {
                String ins = null;
                String outs = null;
                if (!edges.ingoing.isEmpty()) {
                    ins = StringUtils.join(edges.ingoing, (String)", ");
                }
                if (!edges.outgoing.isEmpty()) {
                    outs = StringUtils.join(edges.outgoing, (String)", ");
                }
                if (ins != null || outs != null) {
                    res.append(" [");
                    if (ins != null) {
                        res.append("in: ").append(ins);
                    }
                    if (outs != null) {
                        if (ins != null) {
                            res.append(", ");
                        }
                        res.append("out: ").append(outs);
                    }
                    res.append("]");
                }
            }
            res.append("\n");
            if (!this.cutoff.contains(i)) continue;
            res.append("-----\n");
        }
        return res.toString();
    }

    public void removeFrom(N root) {
        if (!this.containsNode(root)) {
            return;
        }
        HashSet<Object> add = new HashSet<Object>();
        HashSet<Object> remove = new HashSet<Object>();
        HashSet<CodeNode> check = new HashSet<CodeNode>();
        if (this.containsNode(root)) {
            add.add(root);
        } else {
            for (CodeNode codeNode : this.nodes) {
                if (!codeNode.equals(root)) continue;
                add.add(codeNode);
            }
        }
        do {
            remove.addAll(add);
            check.clear();
            for (CodeNode codeNode : add) {
                for (CodeNode next : this.followersOf(codeNode)) {
                    check.add(next);
                }
            }
            add.clear();
            check.stream().filter(n -> !remove.contains(n)).forEach(add::add);
        } while (!add.isEmpty());
        this.simplify(remove, Collections.emptyList(), new LinkedList(), new HashMap());
    }

    public Collection<N> getEntries() {
        return (Collection)this.nodes.stream().filter(nodes -> this.predecessorsOf(nodes).isEmpty()).collect(new CollectionUtilities.SortedSetCollector());
    }

    public Collection<N> getExits() {
        return (Collection)this.nodes.stream().filter(nodes -> this.followersOf(nodes).isEmpty()).collect(new CollectionUtilities.SortedSetCollector());
    }

    public int distance(N from, N to) {
        if (!this.containsNode(from) || !this.containsNode(to)) {
            return -1;
        }
        IdentityHashMap<Object, Integer> distances = new IdentityHashMap<Object, Integer>(this.nodes.size());
        LinkedList<Object> queue = new LinkedList<Object>();
        distances.put(from, 0);
        queue.add(from);
        while (!queue.isEmpty()) {
            CodeNode x = (CodeNode)queue.peek();
            queue.poll();
            for (CodeNode follower : this.followersOf(x)) {
                if (distances.containsKey(follower)) continue;
                distances.put(follower, (Integer)distances.get(x) + 1);
                queue.add(follower);
            }
        }
        return distances.getOrDefault(to, -1);
    }

    public void mergeWith(NodeList<G, N, E> other) {
        for (CodeNode node : other.getNodes()) {
            this.addNode(node);
        }
        for (CodeEdge edge : other.getEdges()) {
            this.addEdge(edge);
        }
    }

    public void validate(Collection<N> entrypoints) throws ProgramValidationException {
        for (CodeNode node : this.nodes) {
            NodeEdges<G, N, E> edges = this.extraEdges.get(node);
            if (edges == null) continue;
            for (CodeEdge in : edges.ingoing) {
                this.validateEdge(this.nodes, in);
            }
            for (CodeEdge out : edges.outgoing) {
                this.validateEdge(this.nodes, out);
            }
            int idx = this.nodes.indexOf(node);
            if (!edges.ingoing.isEmpty() || idx != 0 && !this.cutoff.contains(idx - 1) || entrypoints.contains(node)) continue;
            throw new ProgramValidationException("Unreachable node that is not marked as entrypoint: " + node);
        }
    }

    private void validateEdge(Collection<N> nodes, E edge) throws ProgramValidationException {
        if (!nodes.contains(edge.getSource())) {
            throw new ProgramValidationException("Invalid edge: '" + edge + "' originates in a node that is not part of the graph");
        }
        if (!nodes.contains(edge.getDestination())) {
            throw new ProgramValidationException("Invalid edge: '" + edge + "' reaches a node that is not part of the graph");
        }
    }

    private static /* synthetic */ NodeEdges lambda$addEdge$3(CodeNode n) {
        return new NodeEdges();
    }

    private static /* synthetic */ NodeEdges lambda$addEdge$2(CodeNode n) {
        return new NodeEdges();
    }

    public static class NodeEdges<G extends CodeGraph<G, N, E>, N extends CodeNode<G, N, E>, E extends CodeEdge<G, N, E>> {
        private final Set<E> ingoing;
        private final Set<E> outgoing;

        private NodeEdges() {
            this.ingoing = new HashSet();
            this.outgoing = new HashSet();
        }

        private NodeEdges(NodeEdges<G, N, E> other) {
            this.ingoing = new HashSet<E>(other.ingoing);
            this.outgoing = new HashSet<E>(other.outgoing);
        }

        public Set<E> getIngoing() {
            return this.ingoing;
        }

        public Set<E> getOutgoing() {
            return this.outgoing;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = prime * result + (this.ingoing == null ? 0 : this.ingoing.hashCode());
            result = prime * result + (this.outgoing == null ? 0 : this.outgoing.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NodeEdges other = (NodeEdges)obj;
            if (this.ingoing == null ? other.ingoing != null : !this.ingoing.equals(other.ingoing)) {
                return false;
            }
            return !(this.outgoing == null ? other.outgoing != null : !this.outgoing.equals(other.outgoing));
        }

        public String toString() {
            return "ins: " + this.ingoing + ", outs: " + this.outgoing;
        }
    }
}

