/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.util.datastructures.graph.code;

import it.unive.lisa.outputs.serializableGraph.SerializableGraph;
import it.unive.lisa.outputs.serializableGraph.SerializableValue;
import it.unive.lisa.util.datastructures.graph.Graph;
import it.unive.lisa.util.datastructures.graph.code.CodeEdge;
import it.unive.lisa.util.datastructures.graph.code.CodeNode;
import it.unive.lisa.util.datastructures.graph.code.NodeList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public abstract class CodeGraph<G extends CodeGraph<G, N, E>, N extends CodeNode<G, N, E>, E extends CodeEdge<G, N, E>>
implements Graph<G, N, E> {
    protected final NodeList<G, N, E> list;
    protected final Collection<N> entrypoints;

    protected CodeGraph(E sequentialSingleton) {
        this.list = new NodeList(sequentialSingleton);
        this.entrypoints = new HashSet<N>();
    }

    protected CodeGraph(Collection<N> entrypoints, NodeList<G, N, E> nodes) {
        this.list = nodes;
        this.entrypoints = entrypoints;
    }

    protected CodeGraph(G other) {
        this.list = new NodeList<G, N, E>(((CodeGraph)other).list);
        this.entrypoints = new ArrayList<N>(((CodeGraph)other).entrypoints);
    }

    public NodeList<G, N, E> getNodeList() {
        return this.list;
    }

    @Override
    public Collection<N> getEntrypoints() {
        return this.entrypoints;
    }

    @Override
    public Collection<N> getNodes() {
        return this.list.getNodes();
    }

    @Override
    public Collection<E> getEdges() {
        return this.list.getEdges();
    }

    @Override
    public void addNode(N node) {
        this.addNode(node, false);
    }

    @Override
    public void addNode(N node, boolean entrypoint) {
        this.list.addNode(node);
        if (entrypoint) {
            this.entrypoints.add(node);
        }
    }

    @Override
    public void addEdge(E edge) {
        this.list.addEdge(edge);
    }

    @Override
    public int getNodesCount() {
        return this.getNodes().size();
    }

    @Override
    public int getEdgesCount() {
        return this.getEdges().size();
    }

    @Override
    public boolean containsNode(N node) {
        return this.list.containsNode(node);
    }

    @Override
    public boolean containsEdge(E edge) {
        return this.list.containsEdge(edge);
    }

    @Override
    public E getEdgeConnecting(N source, N destination) {
        return this.list.getEdgeConnecting(source, destination);
    }

    @Override
    public Collection<E> getEdgesConnecting(N source, N destination) {
        return this.list.getEdgesConnecting(source, destination);
    }

    @Override
    public Collection<E> getIngoingEdges(N node) {
        return this.list.getIngoingEdges(node);
    }

    @Override
    public Collection<E> getOutgoingEdges(N node) {
        return this.list.getOutgoingEdges(node);
    }

    @Override
    public Collection<N> followersOf(N node) {
        return this.list.followersOf(node);
    }

    @Override
    public Collection<N> predecessorsOf(N node) {
        return this.list.predecessorsOf(node);
    }

    @Override
    public SerializableGraph toSerializableGraph(BiFunction<G, N, SerializableValue> descriptionGenerator) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not provide a serialization logic");
    }

    @Override
    public boolean isEqualTo(G graph) {
        if (this == graph) {
            return true;
        }
        if (graph == null) {
            return false;
        }
        if (this.getClass() != graph.getClass()) {
            return false;
        }
        if (this.entrypoints == null ? ((CodeGraph)graph).entrypoints != null : !this.entrypoints.equals(((CodeGraph)graph).entrypoints)) {
            return false;
        }
        return !(this.list == null ? ((CodeGraph)graph).list != null : !this.list.equals(((CodeGraph)graph).list));
    }

    public String toString() {
        return this.list.toString();
    }

    public Set<N> simplify(Class<? extends N> target, Collection<E> removedEdges, Map<Pair<E, E>, E> replacedEdges) {
        Set<CodeNode> targets = this.getNodes().stream().filter(k -> target.isAssignableFrom(k.getClass())).collect(Collectors.toSet());
        targets.forEach(this::preSimplify);
        this.list.simplify(targets, this.entrypoints, removedEdges, replacedEdges);
        return targets;
    }

    public void preSimplify(N node) {
    }
}

