/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.util.datastructures.graph.algorithms;

import it.unive.lisa.util.collections.workset.LIFOWorkingSet;
import it.unive.lisa.util.collections.workset.WorkingSet;
import it.unive.lisa.util.datastructures.graph.Edge;
import it.unive.lisa.util.datastructures.graph.Graph;
import it.unive.lisa.util.datastructures.graph.Node;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class SCCs<G extends Graph<G, N, E>, N extends Node<G, N, E>, E extends Edge<G, N, E>> {
    private final Collection<Collection<N>> sccs = new HashSet<Collection<N>>();

    public Collection<Collection<N>> getSCCs() {
        return this.sccs;
    }

    public Collection<Collection<N>> buildNonTrivial(G graph) {
        this.build(graph);
        HashSet<Collection<N>> toRemove = new HashSet<Collection<N>>();
        for (Collection<N> scc : this.sccs) {
            Node first = (Node)scc.iterator().next();
            if (scc.size() != 1 || graph.followersOf((Node)first).contains(first)) continue;
            toRemove.add(scc);
        }
        this.sccs.removeAll(toRemove);
        return this.sccs;
    }

    public Collection<Collection<N>> build(G graph) {
        this.sccs.clear();
        int index = 0;
        HashMap indexes = new HashMap();
        HashMap lowlinks = new HashMap();
        LIFOWorkingSet ws = LIFOWorkingSet.mk();
        for (Node n : graph.getNodes()) {
            if (indexes.containsKey(n)) continue;
            index = this.strongconnect(graph, indexes, lowlinks, index, ws, n);
        }
        return this.sccs;
    }

    private int strongconnect(G graph, Map<N, Integer> indexes, Map<N, Integer> lowlinks, int index, WorkingSet<N> ws, N v) {
        indexes.put(v, index);
        lowlinks.put(v, index);
        ++index;
        ws.push(v);
        for (Node w : graph.followersOf(v)) {
            if (!indexes.containsKey(w)) {
                index = this.strongconnect(graph, indexes, lowlinks, index, ws, w);
                lowlinks.put(v, Math.min(lowlinks.get(v), lowlinks.get(w)));
                continue;
            }
            if (!ws.getContents().contains(w)) continue;
            lowlinks.put(v, Math.min(lowlinks.get(v), indexes.get(w)));
        }
        if (lowlinks.get(v) == indexes.get(v)) {
            Node w;
            HashSet<Node> scc = new HashSet<Node>();
            w = null;
            do {
                w = (Node)ws.pop();
                scc.add(w);
            } while (w != v);
            this.sccs.add(scc);
        }
        return index;
    }
}

