/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.util.datastructures.graph.algorithms;

import it.unive.lisa.util.collections.workset.WorkingSet;
import it.unive.lisa.util.datastructures.graph.Edge;
import it.unive.lisa.util.datastructures.graph.Graph;
import it.unive.lisa.util.datastructures.graph.Node;
import it.unive.lisa.util.datastructures.graph.algorithms.Fixpoint;
import it.unive.lisa.util.datastructures.graph.algorithms.FixpointException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class BackwardFixpoint<G extends Graph<G, N, E>, N extends Node<G, N, E>, E extends Edge<G, N, E>, T> {
    protected static final String ERROR = "Exception while %s of '%s' in '%s'";
    protected final G graph;
    protected final boolean forceFullEvaluation;

    public BackwardFixpoint(G graph, boolean forceFullEvaluation) {
        this.graph = graph;
        this.forceFullEvaluation = forceFullEvaluation;
    }

    public Map<N, T> fixpoint(Map<N, T> startingPoints, WorkingSet<N> ws, Fixpoint.FixpointImplementation<N, E, T> implementation) throws FixpointException {
        return this.fixpoint(startingPoints, ws, implementation, null);
    }

    public Map<N, T> fixpoint(Map<N, T> startingPoints, WorkingSet<N> ws, Fixpoint.FixpointImplementation<N, E, T> implementation, Map<N, T> initialResult) throws FixpointException {
        HashMap<Node, T> result = initialResult == null ? new HashMap<Node, T>(this.graph.getNodesCount()) : new HashMap<N, T>(initialResult);
        startingPoints.keySet().forEach(ws::push);
        HashSet toProcess = null;
        if (this.forceFullEvaluation) {
            toProcess = new HashSet(this.graph.getNodes());
        }
        while (!ws.isEmpty()) {
            T newApprox;
            Node current = (Node)ws.pop();
            if (current == null) {
                throw new FixpointException("null node encountered during fixpoint in '" + this.graph + "'");
            }
            if (!this.graph.containsNode((Node)current)) {
                throw new FixpointException("'" + current + "' is not part of '" + this.graph + "'");
            }
            T exitstate = this.getExitState(current, startingPoints.get(current), implementation, result);
            if (exitstate == null) {
                throw new FixpointException("'" + current + "' does not have an entry state");
            }
            try {
                newApprox = implementation.semantics(current, exitstate);
            }
            catch (Exception e) {
                throw new FixpointException(String.format(ERROR, "computing semantics", current, this.graph), e);
            }
            Object oldApprox = result.get(current);
            if (oldApprox != null) {
                try {
                    newApprox = implementation.operation(current, newApprox, oldApprox);
                }
                catch (Exception e) {
                    throw new FixpointException(String.format(ERROR, "joining states", current, this.graph), e);
                }
            }
            try {
                if ((!this.forceFullEvaluation || !toProcess.remove(current)) && oldApprox != null && implementation.equality(current, newApprox, oldApprox)) continue;
                result.put(current, newApprox);
                for (Node instr : this.graph.predecessorsOf((Node)current)) {
                    ws.push(instr);
                }
            }
            catch (Exception e) {
                throw new FixpointException(String.format(ERROR, "updating result", current, this.graph), e);
            }
        }
        return result;
    }

    protected T getExitState(N node, T startstate, Fixpoint.FixpointImplementation<N, E, T> implementation, Map<N, T> result) throws FixpointException {
        Collection<N> follows = this.graph.followersOf(node);
        ArrayList<T> states = new ArrayList<T>(follows.size());
        for (Object follow : follows) {
            if (!result.containsKey(follow)) continue;
            Object edge = this.graph.getEdgeConnecting(node, (Object)follow);
            try {
                states.add(implementation.traverse(edge, result.get(follow)));
            }
            catch (Exception e) {
                throw new FixpointException(String.format(ERROR, "computing edge semantics", edge, this.graph), e);
            }
        }
        Object exitstate = startstate;
        try {
            for (Object s : states) {
                if (exitstate == null) {
                    exitstate = s;
                    continue;
                }
                exitstate = implementation.union(node, exitstate, s);
            }
        }
        catch (Exception e) {
            throw new FixpointException(String.format(ERROR, "creating entry state", node, this.graph), e);
        }
        return exitstate;
    }
}

