/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.util.datastructures.graph;

import it.unive.lisa.outputs.serializableGraph.SerializableGraph;
import it.unive.lisa.outputs.serializableGraph.SerializableValue;
import it.unive.lisa.util.datastructures.graph.Edge;
import it.unive.lisa.util.datastructures.graph.GraphVisitor;
import it.unive.lisa.util.datastructures.graph.Node;
import it.unive.lisa.util.datastructures.graph.algorithms.Dominators;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.function.BiFunction;

public interface Graph<G extends Graph<G, N, E>, N extends Node<G, N, E>, E extends Edge<G, N, E>> {
    public Collection<N> getEntrypoints();

    public Collection<N> getNodes();

    public Collection<E> getEdges();

    public void addNode(N var1);

    public void addNode(N var1, boolean var2);

    public void addEdge(E var1);

    public int getNodesCount();

    public int getEdgesCount();

    public boolean containsNode(N var1);

    public boolean containsEdge(E var1);

    public E getEdgeConnecting(N var1, N var2);

    public Collection<E> getEdgesConnecting(N var1, N var2);

    public Collection<E> getIngoingEdges(N var1);

    public Collection<E> getOutgoingEdges(N var1);

    public Collection<N> followersOf(N var1);

    public Collection<N> predecessorsOf(N var1);

    default public SerializableGraph toSerializableGraph() {
        return this.toSerializableGraph(null);
    }

    public SerializableGraph toSerializableGraph(BiFunction<G, N, SerializableValue> var1);

    public boolean isEqualTo(G var1);

    default public <V> void accept(GraphVisitor<G, N, E, V> visitor, V tool) {
        if (!visitor.visit(tool, this)) {
            return;
        }
        for (Node node : this.getNodes()) {
            if (node.accept(visitor, tool)) continue;
            return;
        }
        for (Edge edge : this.getEdges()) {
            if (edge.accept(visitor, tool)) continue;
            return;
        }
    }

    default public Collection<N> getCycleEntries() {
        HashSet<Node> result = new HashSet<Node>();
        Map dominators = new Dominators().build(this);
        Collection<N> entries = this.getEntrypoints();
        for (Node node : this.getNodes()) {
            Collection<Node> preds = this.predecessorsOf(node);
            boolean normal = entries.contains(node);
            boolean back = false;
            for (Node pred : preds) {
                if (dominators.get(pred).contains(node)) {
                    back = true;
                    continue;
                }
                normal = true;
            }
            if (!normal || !back) continue;
            result.add(node);
        }
        return result;
    }
}

