/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.util.datastructures.graph;

import it.unive.lisa.outputs.serializableGraph.SerializableGraph;
import it.unive.lisa.outputs.serializableGraph.SerializableValue;
import it.unive.lisa.util.datastructures.graph.AdjacencyMatrix;
import it.unive.lisa.util.datastructures.graph.Edge;
import it.unive.lisa.util.datastructures.graph.Graph;
import it.unive.lisa.util.datastructures.graph.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.BiFunction;

public abstract class BaseGraph<G extends BaseGraph<G, N, E>, N extends Node<G, N, E>, E extends Edge<G, N, E>>
implements Graph<G, N, E> {
    protected final AdjacencyMatrix<G, N, E> adjacencyMatrix;
    protected final Collection<N> entrypoints;

    protected BaseGraph() {
        this.adjacencyMatrix = new AdjacencyMatrix();
        this.entrypoints = new HashSet<N>();
    }

    protected BaseGraph(Collection<N> entrypoints, AdjacencyMatrix<G, N, E> adjacencyMatrix) {
        this.adjacencyMatrix = adjacencyMatrix;
        this.entrypoints = entrypoints;
    }

    protected BaseGraph(G other) {
        this.adjacencyMatrix = new AdjacencyMatrix<G, N, E>(((BaseGraph)other).adjacencyMatrix);
        this.entrypoints = new ArrayList<N>(((BaseGraph)other).entrypoints);
    }

    public AdjacencyMatrix<G, N, E> getAdjacencyMatrix() {
        return this.adjacencyMatrix;
    }

    @Override
    public Collection<N> getEntrypoints() {
        return this.entrypoints;
    }

    @Override
    public Collection<N> getNodes() {
        return this.adjacencyMatrix.getNodes();
    }

    @Override
    public Collection<E> getEdges() {
        return this.adjacencyMatrix.getEdges();
    }

    @Override
    public void addNode(N node) {
        this.addNode(node, false);
    }

    @Override
    public void addNode(N node, boolean entrypoint) {
        this.adjacencyMatrix.addNode(node);
        if (entrypoint) {
            this.entrypoints.add(node);
        }
    }

    @Override
    public void addEdge(E edge) {
        this.adjacencyMatrix.addEdge(edge);
    }

    @Override
    public int getNodesCount() {
        return this.getNodes().size();
    }

    @Override
    public int getEdgesCount() {
        return this.getEdges().size();
    }

    @Override
    public boolean containsNode(N node) {
        return this.adjacencyMatrix.containsNode(node);
    }

    @Override
    public boolean containsEdge(E edge) {
        return this.adjacencyMatrix.containsEdge(edge);
    }

    @Override
    public E getEdgeConnecting(N source, N destination) {
        return this.adjacencyMatrix.getEdgeConnecting(source, destination);
    }

    @Override
    public Collection<E> getEdgesConnecting(N source, N destination) {
        return this.adjacencyMatrix.getEdgesConnecting(source, destination);
    }

    @Override
    public Collection<E> getIngoingEdges(N node) {
        return this.adjacencyMatrix.getIngoingEdges(node);
    }

    @Override
    public Collection<E> getOutgoingEdges(N node) {
        return this.adjacencyMatrix.getOutgoingEdges(node);
    }

    @Override
    public Collection<N> followersOf(N node) {
        return this.adjacencyMatrix.followersOf(node);
    }

    @Override
    public Collection<N> predecessorsOf(N node) {
        return this.adjacencyMatrix.predecessorsOf(node);
    }

    @Override
    public SerializableGraph toSerializableGraph(BiFunction<G, N, SerializableValue> descriptionGenerator) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not provide a serialization logic");
    }

    @Override
    public boolean isEqualTo(G graph) {
        if (this == graph) {
            return true;
        }
        if (graph == null) {
            return false;
        }
        if (this.getClass() != graph.getClass()) {
            return false;
        }
        if (this.entrypoints == null ? ((BaseGraph)graph).entrypoints != null : !this.entrypoints.equals(((BaseGraph)graph).entrypoints)) {
            return false;
        }
        return !(this.adjacencyMatrix == null ? ((BaseGraph)graph).adjacencyMatrix != null : !this.adjacencyMatrix.equals(((BaseGraph)graph).adjacencyMatrix));
    }

    public String toString() {
        return this.adjacencyMatrix.toString();
    }
}

