/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.util.datastructures.automaton;

import it.unive.lisa.util.datastructures.automaton.State;
import it.unive.lisa.util.datastructures.automaton.TransitionSymbol;
import java.util.Objects;

public final class Transition<T extends TransitionSymbol<T>>
implements Comparable<Transition<T>> {
    private final State source;
    private final State destination;
    private final T symbol;

    public Transition(State source, State destination, T symbol) {
        Objects.requireNonNull(source);
        Objects.requireNonNull(destination);
        this.source = source;
        this.destination = destination;
        this.symbol = symbol;
    }

    public int hashCode() {
        return Objects.hash(this.destination, this.source, this.symbol);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Transition other = (Transition)obj;
        return Objects.equals(this.destination, other.destination) && Objects.equals(this.source, other.source) && Objects.equals(this.symbol, other.symbol);
    }

    public String toString() {
        return this.source.getState() + " [" + this.symbol + "] -> " + this.destination.getState();
    }

    public boolean isEpsilonTransition() {
        return this.symbol.isEpsilon();
    }

    public State getSource() {
        return this.source;
    }

    public T getSymbol() {
        return this.symbol;
    }

    public State getDestination() {
        return this.destination;
    }

    @Override
    public int compareTo(Transition<T> transition) {
        int cmp = this.source.compareTo(transition.source);
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.destination.compareTo(transition.destination);
        if (cmp != 0) {
            return cmp;
        }
        return this.symbol.compareTo(transition.symbol);
    }
}

