/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.util.datastructures.automaton;

public final class State
implements Comparable<State> {
    private final boolean isFinal;
    private final boolean isInitial;
    private final int id;

    public State(int id, boolean isInitial, boolean isFinal) {
        this.isInitial = isInitial;
        this.isFinal = isFinal;
        this.id = id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        result = 31 * result + (this.isFinal ? 1231 : 1237);
        result = 31 * result + (this.isInitial ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        State other = (State)obj;
        if (this.id != other.id) {
            return false;
        }
        if (this.isFinal != other.isFinal) {
            return false;
        }
        return this.isInitial == other.isInitial;
    }

    public String toString() {
        return this.getState() + (this.isInitial ? "[init]" : "") + (this.isFinal ? "[final]" : "");
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public boolean isInitial() {
        return this.isInitial;
    }

    public int getId() {
        return this.id;
    }

    @Override
    public int compareTo(State state) {
        int cmp = Integer.compare(this.id, state.id);
        if (cmp != 0) {
            return cmp;
        }
        cmp = Boolean.compare(this.isInitial, state.isInitial);
        if (cmp != 0) {
            return cmp;
        }
        return Boolean.compare(this.isFinal, state.isFinal);
    }

    public String getState() {
        return "q" + this.id;
    }
}

