/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.util.datastructures.automaton;

import it.unive.lisa.util.collections.workset.FIFOWorkingSet;
import it.unive.lisa.util.datastructures.automaton.AutomataFactory;
import it.unive.lisa.util.datastructures.automaton.CyclicAutomatonException;
import it.unive.lisa.util.datastructures.automaton.State;
import it.unive.lisa.util.datastructures.automaton.Transition;
import it.unive.lisa.util.datastructures.automaton.TransitionSymbol;
import it.unive.lisa.util.datastructures.regex.Atom;
import it.unive.lisa.util.datastructures.regex.EmptySet;
import it.unive.lisa.util.datastructures.regex.RegularExpression;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public abstract class Automaton<A extends Automaton<A, T>, T extends TransitionSymbol<T>>
implements AutomataFactory<A, T> {
    protected final SortedSet<State> states;
    protected final SortedSet<Transition<T>> transitions;
    protected Optional<Boolean> deterministic;
    protected Optional<Boolean> minimized;

    protected Automaton() {
        this.states = new TreeSet<State>();
        this.transitions = new TreeSet<Transition<T>>();
        this.deterministic = Optional.empty();
        this.minimized = Optional.empty();
    }

    protected Automaton(SortedSet<State> states, SortedSet<Transition<T>> transitions) {
        if ((long)states.size() != states.stream().map(State::getId).distinct().count()) {
            throw new IllegalArgumentException("The automaton being created contains multiple states with the same id");
        }
        this.states = states;
        this.transitions = transitions;
        this.deterministic = Optional.empty();
        this.minimized = Optional.empty();
    }

    public SortedSet<State> getStates() {
        return this.states;
    }

    public SortedSet<Transition<T>> getTransitions() {
        return this.transitions;
    }

    public void addState(State s) {
        if (this.states.stream().filter(ss -> ss.getId() == s.getId()).findAny().isPresent()) {
            throw new IllegalArgumentException("A state with id " + s.getId() + " aready exists");
        }
        this.states.add(s);
        this.deterministic = Optional.empty();
        this.minimized = Optional.empty();
    }

    public void addTransition(State from, State to, T input) {
        this.addTransition(new Transition<T>(from, to, input));
    }

    public void addTransition(Transition<T> t) {
        this.transitions.add(t);
        this.deterministic = Optional.empty();
        this.minimized = Optional.empty();
    }

    public void removeTransitions(Set<Transition<T>> ts) {
        this.transitions.removeAll(ts);
        this.deterministic = Optional.empty();
        this.minimized = Optional.empty();
    }

    public void removeStates(Set<State> ts) {
        this.states.removeAll(ts);
        this.deterministic = Optional.empty();
        this.minimized = Optional.empty();
    }

    public A minimize() {
        if (this.minimized.isPresent() && this.minimized.get().booleanValue()) {
            return (A)this;
        }
        Automaton<A, T> a = this;
        if (!this.isDeterministic()) {
            a = this.determinize();
        }
        a = ((Automaton)a.reverse()).determinize();
        a = a.removeUnreachableStates();
        a = ((Automaton)a.reverse()).determinize();
        a = a.removeUnreachableStates();
        a.deterministic = Optional.of(true);
        a.minimized = Optional.of(true);
        return (A)a;
    }

    public SortedSet<Transition<T>> getOutgoingTransitionsFrom(State s) {
        return new TreeSet<Transition<T>>(this.transitions.stream().filter(t -> t.getSource().equals(s)).collect(Collectors.toSet()));
    }

    public SortedSet<Transition<T>> getIngoingTransitionsFrom(State s) {
        return new TreeSet<Transition<T>>(this.transitions.stream().filter(t -> t.getDestination().equals(s)).collect(Collectors.toSet()));
    }

    public SortedSet<State> getFinalStates() {
        TreeSet<State> result = new TreeSet<State>();
        for (State s : this.states) {
            if (!s.isFinal()) continue;
            result.add(s);
        }
        return result;
    }

    public State getInitialState() {
        for (State s : this.states) {
            if (!s.isInitial()) continue;
            return s;
        }
        return null;
    }

    public SortedSet<State> getInitialStates() {
        TreeSet<State> initialStates = new TreeSet<State>();
        for (State s : this.states) {
            if (!s.isInitial()) continue;
            initialStates.add(s);
        }
        return initialStates;
    }

    public A removeUnreachableStates() {
        TreeSet<State> newStates = new TreeSet<State>(this.states);
        TreeSet<Transition<T>> newTransitions = new TreeSet<Transition<T>>(this.transitions);
        HashSet<State> reachableStates = new HashSet<State>();
        HashSet ws = new HashSet();
        HashSet<State> temp = new HashSet<State>();
        reachableStates.addAll(this.getInitialStates());
        this.getInitialStates().forEach(ws::add);
        do {
            for (State s2 : ws) {
                for (Transition transition : this.getOutgoingTransitionsFrom(s2)) {
                    temp.add(transition.getDestination());
                }
            }
            temp.removeAll(reachableStates);
            ws.clear();
            ws.addAll(temp);
            reachableStates.addAll(ws);
        } while (!ws.isEmpty());
        newStates.removeIf(s -> !reachableStates.contains(s));
        newTransitions.removeIf(t -> !reachableStates.contains(t.getSource()) || !reachableStates.contains(t.getDestination()));
        return this.from(newStates, newTransitions);
    }

    public A reverse() {
        TreeSet tr = new TreeSet();
        TreeSet<State> st = new TreeSet<State>();
        HashMap<State, State> revStates = new HashMap<State, State>();
        for (State state : this.states) {
            boolean fin = false;
            boolean init = false;
            if (state.isInitial()) {
                fin = true;
            }
            if (state.isFinal()) {
                init = true;
            }
            State q = new State(state.getId(), init, fin);
            st.add(q);
            revStates.put(state, q);
        }
        for (Transition transition : this.transitions) {
            tr.add(new Transition<TransitionSymbol>((State)revStates.get(transition.getDestination()), (State)revStates.get(transition.getSource()), (TransitionSymbol)transition.getSymbol().reverse()));
        }
        return this.from(st, tr);
    }

    public SortedSet<State> epsilonClosure(State s) {
        TreeSet<State> paths = new TreeSet<State>();
        TreeSet<Object> previous = new TreeSet();
        paths.add(s);
        while (!((Object)paths).equals(previous)) {
            previous = new TreeSet<State>((SortedSet<State>)paths);
            TreeSet<State> partial = new TreeSet<State>();
            for (State reached : paths) {
                for (Transition transition : this.getOutgoingTransitionsFrom(reached)) {
                    if (!transition.isEpsilonTransition()) continue;
                    partial.add(transition.getDestination());
                }
            }
            paths.addAll(partial);
        }
        return paths;
    }

    public SortedSet<State> epsilonClosure(Set<State> set) {
        TreeSet<State> solution = new TreeSet<State>();
        for (State s : set) {
            solution.addAll(this.epsilonClosure(s));
        }
        return solution;
    }

    public SortedSet<State> nextStatesNFA(Set<State> set, T sym) {
        TreeSet<State> solution = new TreeSet<State>();
        for (State s : set) {
            for (Transition transition : this.getOutgoingTransitionsFrom(s)) {
                if (!transition.getSymbol().equals(sym)) continue;
                solution.add(transition.getDestination());
            }
        }
        return solution;
    }

    private static boolean containsInitialState(Set<State> states) {
        for (State s : states) {
            if (!s.isInitial()) continue;
            return true;
        }
        return false;
    }

    private static boolean containsFinalState(Set<State> states) {
        for (State s : states) {
            if (!s.isFinal()) continue;
            return true;
        }
        return false;
    }

    public SortedSet<T> getReadableSymbolsFromStates(Set<State> states) {
        TreeSet result = new TreeSet();
        for (State s : states) {
            for (Transition transition : this.getOutgoingTransitionsFrom(s)) {
                if (transition.getSymbol().isEpsilon()) continue;
                result.add(transition.getSymbol());
            }
        }
        return result;
    }

    public SortedSet<T> getReadableSymbolsFromState(State state) {
        TreeSet result = new TreeSet();
        for (Transition transition : this.getOutgoingTransitionsFrom(state)) {
            if (transition.getSymbol().isEpsilon()) continue;
            result.add(transition.getSymbol());
        }
        return result;
    }

    public boolean isDeterministic() {
        if (this.deterministic.isPresent()) {
            return this.deterministic.get();
        }
        if (this.states.stream().filter(s -> s.isInitial()).collect(Collectors.toSet()).size() > 1) {
            this.deterministic = Optional.of(false);
            return false;
        }
        this.deterministic = Optional.of(false);
        for (State s2 : this.states) {
            SortedSet<Transition<T>> outgoingTranisitions = this.getOutgoingTransitionsFrom(s2);
            for (Transition transition : outgoingTranisitions) {
                if (transition.getSymbol().isEpsilon()) {
                    return false;
                }
                for (Transition transition2 : outgoingTranisitions) {
                    if (transition2.getSymbol().isEpsilon()) {
                        return false;
                    }
                    if (transition.getDestination().equals(transition2.getDestination()) || !transition.getSymbol().equals(transition2.getSymbol())) continue;
                    return false;
                }
            }
        }
        this.deterministic = Optional.of(true);
        return true;
    }

    public A determinize() {
        if (this.isDeterministic()) {
            return (A)this;
        }
        TreeSet<State> newStates = new TreeSet<State>();
        TreeSet newDelta = new TreeSet();
        HashMap<Set, Boolean> marked = new HashMap<Set, Boolean>();
        HashMap<SortedSet<State>, State> statesName = new HashMap<SortedSet<State>, State>();
        FIFOWorkingSet<SortedSet<State>> unmarked = FIFOWorkingSet.mk();
        int num = 0;
        SortedSet<State> temp = this.epsilonClosure(this.getInitialStates());
        statesName.put(temp, new State(num++, true, Automaton.containsFinalState(temp)));
        newStates.add((State)statesName.get(temp));
        marked.put(temp, false);
        unmarked.push(temp);
        while (!unmarked.isEmpty()) {
            Set T = (Set)unmarked.pop();
            newStates.add((State)statesName.get(T));
            marked.put(T, true);
            for (TransitionSymbol alphabet : this.getReadableSymbolsFromStates(T)) {
                temp = this.epsilonClosure(this.nextStatesNFA(T, alphabet));
                if (!statesName.containsKey(temp)) {
                    statesName.put(temp, new State(num++, false, Automaton.containsFinalState(temp)));
                }
                newStates.add((State)statesName.get(temp));
                if (!marked.containsKey(temp)) {
                    marked.put(temp, false);
                    unmarked.push(temp);
                }
                newDelta.add(new Transition<TransitionSymbol>((State)statesName.get(T), (State)statesName.get(temp), alphabet));
            }
        }
        Object det = this.from(newStates, newDelta);
        ((Automaton)det).deterministic = Optional.of(true);
        ((Automaton)det).minimized = Optional.of(false);
        return det;
    }

    public A union(A other) {
        if (this == other) {
            return (A)this;
        }
        TreeSet<State> sts = new TreeSet<State>();
        TreeSet ts = new TreeSet();
        TreeSet<State> initStates = new TreeSet<State>();
        HashMap<State, State> thisMapping = new HashMap<State, State>();
        HashMap<State, State> otherMapping = new HashMap<State, State>();
        int c = 1;
        for (State s : this.states) {
            State state = new State(c++, false, s.isFinal());
            thisMapping.put(s, state);
            sts.add(state);
            if (!s.isInitial()) continue;
            initStates.add(state);
        }
        for (State s : ((Automaton)other).states) {
            State state = new State(c++, false, s.isFinal());
            otherMapping.put(s, state);
            sts.add(state);
            if (!s.isInitial()) continue;
            initStates.add(state);
        }
        State q0 = new State(0, true, false);
        sts.add(q0);
        for (State state : initStates) {
            ts.add(new Transition<T>(q0, state, this.epsilon()));
        }
        for (Transition transition : this.transitions) {
            ts.add(new Transition((State)thisMapping.get(transition.getSource()), (State)thisMapping.get(transition.getDestination()), transition.getSymbol()));
        }
        for (Transition transition : ((Automaton)other).transitions) {
            ts.add(new Transition((State)otherMapping.get(transition.getSource()), (State)otherMapping.get(transition.getDestination()), transition.getSymbol()));
        }
        return ((Automaton)this.from(sts, ts)).minimize();
    }

    public boolean hasCycle() {
        SortedSet<State> currentStates = this.getInitialStates();
        TreeSet<State> visited = new TreeSet<State>();
        while (!visited.containsAll(this.states)) {
            TreeSet<State> temp = new TreeSet<State>();
            for (State s : currentStates) {
                for (State follower : this.getNextStates(s)) {
                    if (s == follower || visited.contains(follower)) {
                        return true;
                    }
                    temp.add(follower);
                }
            }
            visited.addAll(currentStates);
            currentStates = temp;
        }
        return false;
    }

    public SortedSet<State> getNextStates(State node) {
        TreeSet<State> neighbors = new TreeSet<State>();
        for (Transition transition : this.getOutgoingTransitionsFrom(node)) {
            neighbors.add(transition.getDestination());
        }
        return neighbors;
    }

    public SortedSet<String> getLanguage() throws CyclicAutomatonException {
        TreeSet<String> lang = new TreeSet<String>();
        if (this.hasCycle()) {
            throw new CyclicAutomatonException();
        }
        if (this.states.size() == 1 && ((State)this.states.iterator().next()).isFinal() && ((State)this.states.iterator().next()).isInitial() && this.transitions.isEmpty()) {
            lang.add("");
            return lang;
        }
        FIFOWorkingSet<Pair> ws = FIFOWorkingSet.mk();
        for (State q : this.getInitialStates()) {
            for (Transition transition : this.getOutgoingTransitionsFrom(q)) {
                ws.push(Pair.of((Object)"", (Object)transition));
            }
        }
        while (!ws.isEmpty()) {
            String sym;
            Pair top = (Pair)ws.pop();
            String currentString = (String)top.getKey();
            Transition tr = (Transition)top.getValue();
            Object t = tr.getSymbol();
            String string = sym = t.isEpsilon() ? "" : t.toString();
            if (tr.getDestination().isFinal()) {
                lang.add(currentString + sym);
            }
            for (Transition transition : this.getOutgoingTransitionsFrom(tr.getDestination())) {
                ws.push(Pair.of((Object)(currentString + sym), (Object)transition));
            }
        }
        return lang;
    }

    public A totalize(Set<T> sigma) {
        TreeSet<State> newStates = new TreeSet<State>(this.states);
        TreeSet<Transition<T>> newTransitions = new TreeSet<Transition<T>>(this.transitions);
        int code = 1 + this.states.stream().map(State::getId).max(Integer::compare).orElseGet(() -> -1);
        State garbage = new State(code, false, false);
        newStates.add(garbage);
        for (State s : this.states) {
            for (TransitionSymbol c : sigma) {
                if (this.getReadableSymbolsFromStates(Collections.singleton(s)).contains(c)) continue;
                newTransitions.add(new Transition<TransitionSymbol>(s, garbage, c));
            }
        }
        for (TransitionSymbol c : sigma) {
            newTransitions.add(new Transition<TransitionSymbol>(garbage, garbage, c));
        }
        return this.from(newStates, newTransitions);
    }

    public A complement(Set<T> sigma) {
        TreeSet<State> sts = new TreeSet<State>();
        TreeSet delta = new TreeSet();
        HashMap<State, State> oldToNew = new HashMap<State, State>();
        A r = ((Automaton)this.determinize()).totalize(sigma != null ? sigma : this.getAlphabet());
        for (State state : ((Automaton)r).states) {
            State q = new State(state.getId(), state.isInitial(), !state.isFinal());
            sts.add(q);
            oldToNew.put(state, q);
        }
        for (Transition transition : ((Automaton)r).transitions) {
            delta.add(new Transition((State)oldToNew.get(transition.getSource()), (State)oldToNew.get(transition.getDestination()), transition.getSymbol()));
        }
        return ((Automaton)this.from(sts, delta)).minimize();
    }

    public A intersection(A other) {
        if (this == other) {
            return (A)this;
        }
        int code = 0;
        HashMap<State, Pair<State, State>> stateMapping = new HashMap<State, Pair<State, State>>();
        TreeSet<State> newStates = new TreeSet<State>();
        TreeSet newDelta = new TreeSet();
        for (State state : this.states) {
            for (State state2 : ((Automaton)other).states) {
                State s = new State(code++, state.isInitial() && state2.isInitial(), state.isFinal() && state2.isFinal());
                stateMapping.put(s, Pair.of((Object)state, (Object)state2));
                newStates.add(s);
            }
        }
        for (Transition transition : this.transitions) {
            for (Transition transition2 : ((Automaton)other).transitions) {
                if (!transition.getSymbol().equals(transition2.getSymbol())) continue;
                State from = this.getStateFromPair(stateMapping, (Pair<State, State>)Pair.of((Object)transition.getSource(), (Object)transition2.getSource()));
                State to = this.getStateFromPair(stateMapping, (Pair<State, State>)Pair.of((Object)transition.getDestination(), (Object)transition2.getDestination()));
                newDelta.add(new Transition(from, to, transition.getSymbol()));
            }
        }
        return ((Automaton)this.from(newStates, newDelta)).minimize();
    }

    protected State getStateFromPair(Map<State, Pair<State, State>> mapping, Pair<State, State> pair) {
        for (Map.Entry<State, Pair<State, State>> entry : mapping.entrySet()) {
            if (!((State)entry.getValue().getLeft()).equals(pair.getLeft()) || !((State)entry.getValue().getRight()).equals(pair.getRight())) continue;
            return entry.getKey();
        }
        return null;
    }

    public boolean acceptsEmptyLanguage() {
        return this.states.stream().noneMatch(State::isFinal);
    }

    public boolean isContained(A other) {
        SortedSet<T> commonAlphabet = this.commonAlphabet(other);
        A complement = ((Automaton)other).complement(commonAlphabet);
        A intersection = this.intersection(complement);
        A minimal = ((Automaton)intersection).minimize();
        return ((Automaton)minimal).acceptsEmptyLanguage();
    }

    public boolean isEqualTo(A other) {
        A o = other;
        if (!this.hasCycle() && !((Automaton)o).hasCycle()) {
            try {
                return this.getLanguage().equals(((Automaton)o).getLanguage());
            }
            catch (CyclicAutomatonException cyclicAutomatonException) {
                // empty catch block
            }
        }
        A a = this.minimize();
        A b = ((Automaton)o).minimize();
        if (((Automaton)a).hasCycle() && !((Automaton)b).hasCycle() || !((Automaton)a).hasCycle() && ((Automaton)b).hasCycle()) {
            return false;
        }
        if (!((Automaton)a).hasCycle() && !((Automaton)b).hasCycle()) {
            try {
                return ((Automaton)a).getLanguage().equals(((Automaton)b).getLanguage());
            }
            catch (CyclicAutomatonException cyclicAutomatonException) {
                // empty catch block
            }
        }
        if (!((Automaton)a).isContained(b)) {
            return false;
        }
        return ((Automaton)b).isContained(a);
    }

    public A copy() {
        TreeSet<State> newStates = new TreeSet<State>();
        TreeSet newTransitions = new TreeSet();
        HashMap<String, State> nameToStates = new HashMap<String, State>();
        for (State state : this.states) {
            State newState = new State(state.getId(), state.isInitial(), state.isFinal());
            newStates.add(newState);
            nameToStates.put(newState.getState(), newState);
        }
        for (Transition transition : this.transitions) {
            newTransitions.add(new Transition((State)nameToStates.get(transition.getSource().getState()), (State)nameToStates.get(transition.getDestination().getState()), transition.getSymbol()));
        }
        return this.from(newStates, newTransitions);
    }

    public SortedSet<T> commonAlphabet(A other) {
        SortedSet<T> sa;
        SortedSet<T> fa = this.getAlphabet();
        if (fa.containsAll(sa = ((Automaton)other).getAlphabet())) {
            return fa;
        }
        if (sa.containsAll(fa)) {
            return sa;
        }
        fa.addAll(sa);
        return fa;
    }

    public SortedSet<T> getAlphabet() {
        TreeSet alphabet = new TreeSet();
        for (Transition transition : this.transitions) {
            alphabet.add(transition.getSymbol());
        }
        return alphabet;
    }

    public SortedSet<T> getNextSymbols(State s, int n) {
        TreeSet result = new TreeSet();
        if (n == 0) {
            return result;
        }
        TreeSet<TransitionSymbol> lang = new TreeSet<TransitionSymbol>();
        FIFOWorkingSet<Triple> stack = FIFOWorkingSet.mk();
        stack.push(Triple.of(this.epsilon(), (Object)s, (Object)n));
        while (!stack.isEmpty()) {
            Triple top = (Triple)stack.pop();
            TransitionSymbol currentString = (TransitionSymbol)top.getLeft();
            SortedSet<T> newChars = this.getReadableSymbolsFromState((State)top.getMiddle());
            for (TransitionSymbol c : newChars) {
                TransitionSymbol newString = this.concat(currentString, c);
                lang.add(newString);
                if ((Integer)top.getRight() - 1 <= 0) continue;
                for (State q : this.getOutgoingTransitionsFrom((State)top.getMiddle()).stream().filter(t -> t.getSymbol().equals(c)).map(Transition::getDestination).collect(Collectors.toSet())) {
                    stack.push(Triple.of((Object)newString, (Object)q, (Object)((Integer)top.getRight() - 1)));
                }
            }
        }
        return lang;
    }

    public A widening(int n) {
        HashMap<SortedSet, SortedSet> powerStates = new HashMap<SortedSet, SortedSet>();
        HashMap<State, SortedSet<T>> languages = new HashMap<State, SortedSet<T>>();
        TreeSet<State> newStates = new TreeSet<State>();
        HashMap<Object, State> mapping = new HashMap<Object, State>();
        for (State state : this.states) {
            SortedSet<T> lang = this.getNextSymbols(state, n);
            languages.put(state, lang);
            powerStates.computeIfAbsent(lang, k -> new TreeSet()).add(state);
        }
        int i = 0;
        for (Object ps : powerStates.values()) {
            State state = new State(i++, Automaton.containsInitialState((Set<State>)ps), Automaton.containsFinalState((Set<State>)ps));
            newStates.add(state);
            mapping.put(ps, state);
        }
        TreeSet treeSet = new TreeSet();
        for (Transition transition : this.transitions) {
            Set fromPartition = (Set)powerStates.get(languages.get(transition.getSource()));
            Set toPartition = (Set)powerStates.get(languages.get(transition.getDestination()));
            treeSet.add(new Transition((State)mapping.get(fromPartition), (State)mapping.get(toPartition), transition.getSymbol()));
        }
        Object automaton = this.from(newStates, treeSet);
        return ((Automaton)automaton).minimize();
    }

    public String toString() {
        return this.toRegex().simplify().toString();
    }

    public String prettyPrint() {
        StringBuilder result = new StringBuilder();
        for (State st : this.states) {
            SortedSet<Transition<T>> transitions = this.getOutgoingTransitionsFrom(st);
            if (transitions.isEmpty() && !st.isFinal() && !st.isInitial()) continue;
            result.append(st.getState()).append(" ");
            if (st.isFinal()) {
                result.append("[accept]");
            } else {
                result.append("[reject]");
            }
            if (st.isInitial()) {
                result.append("[initial]");
            }
            result.append("\n");
            for (Transition transition : transitions) {
                result.append("\t").append(st).append(" [").append(transition.getSymbol()).append("] -> ").append(transition.getDestination()).append("\n");
            }
        }
        return result.toString();
    }

    public A concat(A other) {
        State st;
        TreeSet<State> newStates = new TreeSet<State>();
        TreeSet newTransitions = new TreeSet();
        HashMap<State, State> thisMapping = new HashMap<State, State>();
        HashMap<State, State> otherMapping = new HashMap<State, State>();
        TreeSet<State> thisFinalStates = new TreeSet<State>();
        TreeSet<State> otherInitialStates = new TreeSet<State>();
        int c = 0;
        for (State state : this.states) {
            st = new State(c++, state.isInitial(), false);
            thisMapping.put(state, st);
            newStates.add(st);
            if (!state.isFinal()) continue;
            thisFinalStates.add(st);
        }
        for (State state : ((Automaton)other).states) {
            st = new State(c++, false, state.isFinal());
            otherMapping.put(state, st);
            newStates.add(st);
            if (!state.isInitial()) continue;
            otherInitialStates.add(st);
        }
        for (Transition transition : this.transitions) {
            newTransitions.add(new Transition((State)thisMapping.get(transition.getSource()), (State)thisMapping.get(transition.getDestination()), transition.getSymbol()));
        }
        for (Transition transition : ((Automaton)other).transitions) {
            newTransitions.add(new Transition((State)otherMapping.get(transition.getSource()), (State)otherMapping.get(transition.getDestination()), transition.getSymbol()));
        }
        for (State state : thisFinalStates) {
            for (State i : otherInitialStates) {
                newTransitions.add(new Transition<T>(state, i, this.epsilon()));
            }
        }
        return ((Automaton)this.from(newStates, newTransitions)).minimize();
    }

    public A toSingleInitalState() {
        SortedSet<State> initialStates = this.getInitialStates();
        if (initialStates.size() < 2) {
            return (A)this;
        }
        TreeSet<State> newStates = new TreeSet<State>();
        HashMap<Integer, State> nameToStates = new HashMap<Integer, State>();
        TreeSet newDelta = new TreeSet();
        int max = -1;
        for (State state : this.states) {
            State mock = new State(state.getId(), false, state.isFinal());
            newStates.add(mock);
            nameToStates.put(state.getId(), mock);
            max = Math.max(max, state.getId());
        }
        for (Transition transition : this.transitions) {
            newDelta.add(new Transition((State)nameToStates.get(transition.getSource().getId()), (State)nameToStates.get(transition.getDestination().getId()), transition.getSymbol()));
        }
        State newInit = new State(max + 1, true, false);
        newStates.add(newInit);
        for (State init : initialStates) {
            newDelta.add(new Transition<T>(newInit, (State)nameToStates.get(init.getId()), this.epsilon()));
        }
        return this.from(newStates, newDelta);
    }

    public RegularExpression toRegex() {
        int j;
        A a = this.minimize();
        if (((Automaton)a).getInitialStates().isEmpty()) {
            return EmptySet.INSTANCE;
        }
        if (((Automaton)a).states.size() == 1 && ((Automaton)a).transitions.size() == 0) {
            return Atom.EPSILON;
        }
        if (((Automaton)a).states.size() == 1) {
            RegularExpression regex = null;
            for (Transition transition : ((Automaton)a).transitions) {
                if (regex == null) {
                    regex = this.symbolToRegex(transition.getSymbol());
                    continue;
                }
                regex = regex.or(this.symbolToRegex(transition.getSymbol()));
            }
            return regex.star();
        }
        if (((Automaton)a).transitions.size() == 1) {
            return this.symbolToRegex(((Transition)((Automaton)a).transitions.stream().findFirst().get()).getSymbol());
        }
        a = ((Automaton)a).toSingleInitalState();
        int m = ((Automaton)a).states.size();
        RegularExpression[][] A = new RegularExpression[m][m];
        RegularExpression[] regularExpressionArray = new RegularExpression[m];
        HashMap<Integer, State> mapping = new HashMap<Integer, State>();
        mapping.put(0, ((Automaton)a).states.stream().filter(State::isInitial).findFirst().get());
        Iterator<State> it = ((Automaton)a).states.iterator();
        for (int i = 0; i < m; ++i) {
            State source = (State)mapping.get(i);
            if (source == null) {
                source = Automaton.nextNonInitialState(it);
                mapping.put(i, source);
            }
            regularExpressionArray[i] = source.isFinal() ? Atom.EPSILON : EmptySet.INSTANCE;
            for (j = 0; j < m; ++j) {
                Iterator tt;
                State dest = (State)mapping.get(j);
                if (dest == null) {
                    dest = Automaton.nextNonInitialState(it);
                    mapping.put(j, dest);
                }
                if (!(tt = ((Automaton)a).getAllTransitionsConnecting(source, dest).iterator()).hasNext()) {
                    A[i][j] = EmptySet.INSTANCE;
                    continue;
                }
                A[i][j] = this.symbolToRegex(((Transition)tt.next()).getSymbol());
                while (tt.hasNext()) {
                    A[i][j] = A[i][j].or(this.symbolToRegex(((Transition)tt.next()).getSymbol()));
                }
            }
        }
        for (int n = m - 1; n >= 0; --n) {
            RegularExpression star_nn = A[n][n].star();
            regularExpressionArray[n] = star_nn.comp(regularExpressionArray[n]);
            for (j = 0; j < n; ++j) {
                A[n][j] = star_nn.comp(A[n][j]);
            }
            for (int i = 0; i < n; ++i) {
                regularExpressionArray[i] = regularExpressionArray[i].or(A[i][n].comp(regularExpressionArray[n]));
                for (int j2 = 0; j2 < n; ++j2) {
                    A[i][j2] = A[i][j2].or(A[i][n].comp(A[n][j2]));
                }
            }
        }
        return regularExpressionArray[0];
    }

    private static State nextNonInitialState(Iterator<State> it) {
        while (it.hasNext()) {
            State cursor = it.next();
            if (cursor.isInitial()) continue;
            return cursor;
        }
        return null;
    }

    public SortedSet<Transition<T>> getAllTransitionsConnecting(State s1, State s2) {
        TreeSet<Transition<T>> result = new TreeSet<Transition<T>>();
        for (Transition transition : this.transitions) {
            if (!transition.getSource().equals(s1) || !transition.getDestination().equals(s2)) continue;
            result.add(transition);
        }
        return result;
    }

    public A star() {
        TreeSet tr = new TreeSet();
        TreeSet<State> st = new TreeSet<State>();
        HashMap<State, State> mapping = new HashMap<State, State>();
        for (State state : this.states) {
            State q = new State(state.getId(), state.isInitial(), state.isInitial() || state.isFinal());
            st.add(q);
            mapping.put(state, q);
        }
        for (Transition transition : this.transitions) {
            tr.add(new Transition((State)mapping.get(transition.getSource()), (State)mapping.get(transition.getDestination()), transition.getSymbol()));
        }
        for (State state : this.getFinalStates()) {
            for (State i : this.getInitialStates()) {
                tr.add(new Transition<T>((State)mapping.get(state), (State)mapping.get(i), this.epsilon()));
            }
        }
        return this.from(st, tr);
    }

    public boolean areMutuallyReachable(State s1, State s2) {
        return !this.minimumPath(s1, s2).isEmpty() && !this.minimumPath(s2, s1).isEmpty();
    }

    public Set<List<State>> getAllPaths() {
        HashSet<List<State>> result = new HashSet<List<State>>();
        for (State initial : this.getInitialStates()) {
            Set<Transition<T>[]> paths = this.depthFirst(initial);
            for (Transition<T>[] tt : paths) {
                ArrayList<State> path = new ArrayList<State>(tt.length + 1);
                for (Transition<T> t : tt) {
                    path.add(t.getSource());
                    if (!t.getDestination().isFinal()) continue;
                    path.add(t.getDestination());
                }
                Automaton.simplify(path);
                result.add(path);
            }
        }
        return result;
    }

    private Set<Transition<T>[]> depthFirst(State src) {
        HashSet<Transition<T>[]> paths = new HashSet<Transition<T>[]>();
        Stack<Triple> ws = new Stack<Triple>();
        ws.push(Triple.of((Object)src, (Object)new Transition[0], (Object)new int[0]));
        do {
            Triple current = (Triple)ws.pop();
            State node = (State)current.getLeft();
            Transition[] visited = (Transition[])current.getMiddle();
            int[] hashes = (int[])current.getRight();
            int len = visited.length;
            SortedSet<Transition<T>> tr = this.getOutgoingTransitionsFrom(node);
            block1: for (Transition transition : tr) {
                int thash = transition.hashCode();
                int count = 0;
                for (int i = 0; i < len; ++i) {
                    if (visited[i] == transition || hashes[i] == thash && transition.equals(visited[i])) {
                        ++count;
                    }
                    if (count > 1) continue block1;
                }
                Transition[] copy = Arrays.copyOf(visited, len + 1);
                int[] hashesCopy = Arrays.copyOf(hashes, len + 1);
                copy[len] = transition;
                hashesCopy[len] = thash;
                if (transition.getDestination().isFinal()) {
                    paths.add(copy);
                }
                ws.push(Triple.of((Object)transition.getDestination(), (Object)copy, (Object)hashesCopy));
            }
        } while (!ws.isEmpty());
        return paths;
    }

    private static void simplify(List<State> path) {
        ListIterator<State> it = path.listIterator();
        while (it.hasNext()) {
            State current;
            if (!it.hasPrevious()) {
                it.next();
                continue;
            }
            it.previous();
            State previous = it.next();
            if (!previous.equals(current = it.next())) continue;
            it.remove();
        }
    }

    public List<State> minimumPath(State src, State target) {
        HashSet<State> unSettledNodes = new HashSet<State>();
        HashMap<State, Integer> distance = new HashMap<State, Integer>();
        HashMap<State, State> predecessors = new HashMap<State, State>();
        distance.put(src, 0);
        unSettledNodes.add(src);
        while (unSettledNodes.size() > 0) {
            State node = Automaton.getMinimum(unSettledNodes, distance);
            unSettledNodes.remove(node);
            this.findMinimalDistances(node, distance, predecessors, unSettledNodes);
        }
        return Automaton.getPath(target, predecessors);
    }

    private void findMinimalDistances(State node, Map<State, Integer> distance, Map<State, State> predecessors, Set<State> unSettledNodes) {
        SortedSet<State> adjacentNodes = this.getNextStates(node);
        int shortest = Automaton.getShortestDistance(node, distance);
        for (State target : adjacentNodes) {
            int dist = this.getDistance(node, target);
            if (Automaton.getShortestDistance(target, distance) <= shortest + dist) continue;
            distance.put(target, shortest + dist);
            predecessors.put(target, node);
            unSettledNodes.add(target);
        }
    }

    private int getDistance(State node, State target) {
        if (!this.getAllTransitionsConnecting(node, target).isEmpty()) {
            return 1;
        }
        return -1;
    }

    private static State getMinimum(Set<State> vertexes, Map<State, Integer> distance) {
        State minimum = null;
        for (State vertex : vertexes) {
            if (minimum == null) {
                minimum = vertex;
                continue;
            }
            if (Automaton.getShortestDistance(vertex, distance) >= Automaton.getShortestDistance(minimum, distance)) continue;
            minimum = vertex;
        }
        return minimum;
    }

    private static int getShortestDistance(State destination, Map<State, Integer> distance) {
        Integer d = distance.get(destination);
        if (d == null) {
            return Integer.MAX_VALUE;
        }
        return d;
    }

    private static List<State> getPath(State target, Map<State, State> predecessors) {
        LinkedList<State> path = new LinkedList<State>();
        State step = target;
        if (predecessors.get(step) == null) {
            path.add(target);
            return path;
        }
        path.add(step);
        while (predecessors.get(step) != null) {
            step = predecessors.get(step);
            path.add(step);
        }
        Collections.reverse(path);
        return path;
    }

    public List<State> maximumPath(State src, State target) {
        HashSet<State> unSettledNodes = new HashSet<State>();
        HashMap<State, Integer> distance = new HashMap<State, Integer>();
        HashMap<State, State> predecessors = new HashMap<State, State>();
        distance.put(src, 0);
        unSettledNodes.add(src);
        while (unSettledNodes.size() > 0) {
            State node = Automaton.getMaximum(unSettledNodes, distance);
            unSettledNodes.remove(node);
            this.findMaximumDistances(node, distance, predecessors, unSettledNodes);
        }
        return Automaton.getPath(target, predecessors);
    }

    private void findMaximumDistances(State node, Map<State, Integer> distance, Map<State, State> predecessors, Set<State> unSettledNodes) {
        SortedSet<State> adjacentNodes = this.getNextStates(node);
        int longest = Automaton.getLongestDistance(node, distance);
        for (State target : adjacentNodes) {
            int dist = this.getDistance(node, target);
            if (Automaton.getLongestDistance(target, distance) >= longest + dist) continue;
            distance.put(target, longest + dist);
            predecessors.put(target, node);
            unSettledNodes.add(target);
        }
    }

    private static State getMaximum(Set<State> vertexes, Map<State, Integer> distance) {
        State maximum = null;
        for (State vertex : vertexes) {
            if (maximum == null) {
                maximum = vertex;
                continue;
            }
            if (Automaton.getLongestDistance(vertex, distance) <= Automaton.getLongestDistance(maximum, distance)) continue;
            maximum = vertex;
        }
        return maximum;
    }

    private static int getLongestDistance(State destination, Map<State, Integer> distance) {
        Integer d = distance.get(destination);
        if (d == null) {
            return Integer.MIN_VALUE;
        }
        return d;
    }

    public boolean hasOnlyOnePath() throws CyclicAutomatonException {
        A a = this.minimize();
        if (((Automaton)a).hasCycle()) {
            throw new CyclicAutomatonException();
        }
        HashSet<State> transFrom = new HashSet<State>();
        HashSet<State> transTo = new HashSet<State>();
        State from = null;
        State to = null;
        for (Transition transition : ((Automaton)a).transitions) {
            from = transition.getSource();
            if (transFrom.contains(from)) {
                return false;
            }
            transFrom.add(from);
            to = transition.getDestination();
            if (transTo.contains(to)) {
                return false;
            }
            transTo.add(to);
        }
        return true;
    }

    public A extractLongestString() {
        State lastFinalState = null;
        for (State finalState : this.getFinalStates()) {
            SortedSet<Transition<T>> outgoingTransaction = this.getOutgoingTransitionsFrom(finalState);
            if (!outgoingTransaction.isEmpty()) continue;
            lastFinalState = finalState;
        }
        State nextState = this.getInitialState();
        LinkedList symbols = new LinkedList();
        while (!nextState.equals(lastFinalState)) {
            for (Transition transition : this.transitions) {
                if (!transition.getSource().equals(nextState)) continue;
                nextState = transition.getDestination();
                symbols.add(transition.getSymbol());
            }
        }
        TreeSet<State> newStates = new TreeSet<State>();
        TreeSet treeSet = new TreeSet();
        int counter = 0;
        State last = new State(counter++, true, symbols.isEmpty());
        newStates.add(last);
        for (TransitionSymbol symbol : symbols) {
            State tail = new State(counter++, false, counter - 1 == symbols.size());
            newStates.add(tail);
            treeSet.add(new Transition<TransitionSymbol>(last, tail, symbol));
            last = tail;
        }
        return this.from(newStates, treeSet);
    }

    public A makeAcyclic() {
        Set<List<State>> paths = this.getAllPaths();
        paths = paths.stream().filter(p -> p.stream().distinct().collect(Collectors.toList()).equals(p)).collect(Collectors.toSet());
        TreeSet<State> states = new TreeSet<State>();
        TreeSet delta = new TreeSet();
        for (List<State> p2 : paths) {
            for (State s : p2) {
                states.add(s);
                for (Transition transition : this.getOutgoingTransitionsFrom(s)) {
                    if (!p2.contains(transition.getDestination()) || states.contains(transition.getDestination())) continue;
                    delta.add(transition);
                }
            }
        }
        return this.from(states, delta);
    }

    public A factors() {
        TreeSet<State> newStates = new TreeSet<State>();
        HashMap<Integer, State> nameToStates = new HashMap<Integer, State>();
        TreeSet newDelta = new TreeSet();
        for (State state : this.states) {
            State mock = new State(state.getId(), true, true);
            newStates.add(mock);
            nameToStates.put(state.getId(), mock);
        }
        for (Transition transition : this.transitions) {
            newDelta.add(new Transition((State)nameToStates.get(transition.getSource().getId()), (State)nameToStates.get(transition.getDestination().getId()), transition.getSymbol()));
        }
        return ((Automaton)this.from(newStates, newDelta)).minimize();
    }

    public A prefix() {
        TreeSet<State> newStates = new TreeSet<State>();
        HashMap<Integer, State> nameToStates = new HashMap<Integer, State>();
        TreeSet newDelta = new TreeSet();
        for (State state : this.states) {
            State mock = new State(state.getId(), state.isInitial(), true);
            newStates.add(mock);
            nameToStates.put(state.getId(), mock);
        }
        for (Transition transition : this.transitions) {
            newDelta.add(new Transition((State)nameToStates.get(transition.getSource().getId()), (State)nameToStates.get(transition.getDestination().getId()), transition.getSymbol()));
        }
        return ((Automaton)this.from(newStates, newDelta)).minimize();
    }

    public A suffix() {
        TreeSet<State> newStates = new TreeSet<State>();
        HashMap<Integer, State> nameToStates = new HashMap<Integer, State>();
        TreeSet newDelta = new TreeSet();
        for (State state : this.states) {
            State mock = new State(state.getId(), true, state.isFinal());
            newStates.add(mock);
            nameToStates.put(state.getId(), mock);
        }
        for (Transition transition : this.transitions) {
            newDelta.add(new Transition((State)nameToStates.get(transition.getSource().getId()), (State)nameToStates.get(transition.getDestination().getId()), transition.getSymbol()));
        }
        return ((Automaton)this.from(newStates, newDelta)).minimize();
    }

    public int lenghtOfLongestString() {
        Set<List<State>> paths = this.getAllPaths();
        if (paths.size() == 0) {
            return 0;
        }
        int max = Integer.MIN_VALUE;
        for (List<State> v : paths) {
            int tmp = this.maxStringLengthTraversing(v);
            if (tmp == Integer.MAX_VALUE) {
                return tmp;
            }
            if (tmp <= max) continue;
            max = tmp;
        }
        return max;
    }

    private int maxStringLengthTraversing(List<State> path) {
        if (path.size() == 0) {
            return 0;
        }
        if (path.size() == 1) {
            return this.maxStringLength(path.get(0), path.get(0));
        }
        int len = 0;
        for (int i = 0; i < path.size() - 1; ++i) {
            int l = this.maxStringLength(path.get(i), path.get(i + 1));
            if (l == Integer.MAX_VALUE) {
                return l;
            }
            len += l;
        }
        return len;
    }

    private int maxStringLength(State from, State to) {
        SortedSet<Transition<T>> transitions = this.getAllTransitionsConnecting(from, to);
        if (transitions.isEmpty()) {
            return 0;
        }
        if (transitions.size() == 1) {
            return ((Transition)transitions.iterator().next()).getSymbol().maxLength();
        }
        int len = -1;
        for (Transition transition : transitions) {
            if (len == -1) {
                len = transition.getSymbol().maxLength();
                continue;
            }
            len = Math.max(len, transition.getSymbol().maxLength());
        }
        return len;
    }

    public boolean recognizesExactlyOneString() {
        if (this.hasCycle()) {
            return false;
        }
        for (State s : this.getStates()) {
            if (this.getOutgoingTransitionsFrom(s).size() <= 1) continue;
            return false;
        }
        return true;
    }

    public A factorsChangingInitialState(State s) {
        TreeSet<State> newStates = new TreeSet<State>();
        HashMap<Integer, State> nameToStates = new HashMap<Integer, State>();
        TreeSet newDelta = new TreeSet();
        for (State state : this.states) {
            State mock = new State(state.getId(), state == s, true);
            newStates.add(mock);
            nameToStates.put(state.getId(), mock);
        }
        for (Transition transition : this.transitions) {
            newDelta.add(new Transition((State)nameToStates.get(transition.getSource().getId()), (State)nameToStates.get(transition.getDestination().getId()), transition.getSymbol()));
        }
        return ((Automaton)this.from(newStates, newDelta)).minimize();
    }

    public int hashCode() {
        return Objects.hash(this.states, this.transitions);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Automaton other = (Automaton)obj;
        return Objects.equals(this.states, other.states) && Objects.equals(this.transitions, other.transitions);
    }

    public abstract T epsilon();

    public abstract T concat(T var1, T var2);

    public abstract RegularExpression symbolToRegex(T var1);
}

