/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.util.collections.externalSet;

import it.unive.lisa.util.collections.externalSet.ExternalSetCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

public interface ExternalSet<T>
extends Set<T> {
    public ExternalSetCache<T> getCache();

    default public void addAll(ExternalSet<T> other) {
        if (this == other) {
            return;
        }
        if (other == null) {
            return;
        }
        if (this.getCache() != other.getCache()) {
            return;
        }
        for (Object element : other) {
            this.add(element);
        }
    }

    default public Collection<T> collect() {
        ArrayList list = new ArrayList();
        for (Object e : this) {
            list.add(e);
        }
        return list;
    }

    public ExternalSet<T> copy();

    default public boolean contains(ExternalSet<T> other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getCache() != other.getCache()) {
            return false;
        }
        for (Object element : other) {
            if (this.contains(element)) continue;
            return false;
        }
        return true;
    }

    default public boolean intersects(ExternalSet<T> other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getCache() != other.getCache()) {
            return false;
        }
        for (Object element : other) {
            if (!this.contains(element)) continue;
            return true;
        }
        return false;
    }

    default public ExternalSet<T> intersection(ExternalSet<T> other) {
        if (this == other) {
            return this;
        }
        if (other == null) {
            return this;
        }
        if (this.getCache() != other.getCache()) {
            return this;
        }
        ExternalSet<T> result = this.copy();
        for (Object element : other) {
            if (this.contains(element)) continue;
            result.remove(element);
        }
        return result;
    }

    default public ExternalSet<T> difference(ExternalSet<T> other) {
        if (this == other) {
            return this;
        }
        if (other == null) {
            return this;
        }
        if (this.getCache() != other.getCache()) {
            return this;
        }
        ExternalSet<T> result = this.copy();
        for (Object element : other) {
            if (!this.contains(element)) continue;
            result.remove(element);
        }
        return result;
    }

    default public ExternalSet<T> union(ExternalSet<T> other) {
        if (this == other) {
            return this;
        }
        if (other == null) {
            return this;
        }
        if (this.getCache() != other.getCache()) {
            return this;
        }
        ExternalSet<T> result = this.copy();
        for (Object element : other) {
            if (this.contains(element)) continue;
            result.add(element);
        }
        return result;
    }

    default public boolean anyMatch(Predicate<T> predicate) {
        for (Object t : this) {
            if (!predicate.test(t)) continue;
            return true;
        }
        return false;
    }

    default public boolean noneMatch(Predicate<T> predicate) {
        for (Object t : this) {
            if (!predicate.test(t)) continue;
            return false;
        }
        return true;
    }

    default public boolean allMatch(Predicate<T> predicate) {
        for (Object t : this) {
            if (predicate.test(t)) continue;
            return false;
        }
        return true;
    }

    default public ExternalSet<T> filter(Predicate<T> predicate) {
        ExternalSet<T> result = this.copy();
        for (Object t : this) {
            if (predicate.test(t)) continue;
            result.remove(t);
        }
        return result;
    }

    default public ExternalSet<T> transform(UnaryOperator<T> transformer) {
        ExternalSet<T> result = this.getCache().mkEmptySet();
        for (Object t : this) {
            result.add(transformer.apply(t));
        }
        return result;
    }

    default public ExternalSet<T> multiTransform(Function<T, Collection<T>> transformer) {
        ExternalSet<T> result = this.getCache().mkEmptySet();
        for (Object t : this) {
            result.addAll(transformer.apply(t));
        }
        return result;
    }

    default public T reduce(T base, BinaryOperator<T> reducer) {
        Object result = base;
        for (Object t : this) {
            result = reducer.apply(result, t);
        }
        return result;
    }

    default public T first() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return (T)this.iterator().next();
    }
}

