/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.util.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public final class CollectionUtilities {
    private CollectionUtilities() {
    }

    public static <T> int nullSafeCompare(boolean nullFirst, T left, T right, Comparator<T> comparator) {
        if (left == null && right != null) {
            return nullFirst ? -1 : 1;
        }
        if (left != null && right == null) {
            return nullFirst ? 1 : -1;
        }
        if (left == null) {
            return 0;
        }
        return comparator.compare(left, right);
    }

    public static <T, C extends Collection<T>> boolean equals(C first, C second, BiPredicate<T, T> equalityTest) {
        HashSet copy = new HashSet(second);
        for (T t1 : first) {
            boolean found = false;
            for (T t2 : second) {
                if (!copy.contains(t2) || !equalityTest.test(t1, t2)) continue;
                copy.remove(t2);
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return copy.isEmpty();
    }

    public static <T, C extends Collection<T>> void join(C first, C second, C result, BiPredicate<T, T> equalityTest, BinaryOperator<T> joiner) {
        HashSet copy = new HashSet(second);
        for (T t1 : first) {
            boolean found = false;
            for (T t2 : second) {
                if (!copy.contains(t2) || !equalityTest.test(t1, t2)) continue;
                copy.remove(t2);
                found = true;
                result.add(joiner.apply(t1, t2));
                break;
            }
            if (found) continue;
            result.add(t1);
        }
        copy.forEach(result::add);
    }

    public static <T, C extends Collection<T>> void meet(C first, C second, C result, BiPredicate<T, T> equalityTest, BinaryOperator<T> meet) {
        HashSet copy = new HashSet(second);
        block0: for (T t1 : first) {
            for (T t2 : second) {
                if (!copy.contains(t2) || !equalityTest.test(t1, t2)) continue;
                copy.remove(t2);
                result.add(meet.apply(t1, t2));
                continue block0;
            }
        }
    }

    @SafeVarargs
    public static <T> Collection<T> collect(T ... objs) {
        ArrayList<T> res = new ArrayList<T>(objs.length);
        for (T o : objs) {
            res.add(o);
        }
        return res;
    }

    public static class StringCollector<E>
    implements Collector<E, StringBuilder, String> {
        private final String separator;

        public StringCollector(String separator) {
            this.separator = separator;
        }

        @Override
        public Supplier<StringBuilder> supplier() {
            return () -> new StringBuilder();
        }

        @Override
        public BiConsumer<StringBuilder, E> accumulator() {
            return (builder, e) -> {
                if (builder.length() == 0) {
                    builder.append(e);
                } else {
                    builder.append(this.separator).append(e);
                }
            };
        }

        @Override
        public BinaryOperator<StringBuilder> combiner() {
            return (result, partial) -> result.append((CharSequence)partial);
        }

        @Override
        public Function<StringBuilder, String> finisher() {
            return builder -> builder.toString();
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return Collections.emptySet();
        }
    }

    public static class SortedSetCollector<E>
    implements Collector<E, SortedSet<E>, SortedSet<E>> {
        @Override
        public Supplier<SortedSet<E>> supplier() {
            return () -> new TreeSet();
        }

        @Override
        public BiConsumer<SortedSet<E>, E> accumulator() {
            return (set, e) -> set.add(e);
        }

        @Override
        public BinaryOperator<SortedSet<E>> combiner() {
            return (result, partial) -> {
                result.addAll(partial);
                return result;
            };
        }

        @Override
        public Function<SortedSet<E>, SortedSet<E>> finisher() {
            return Function.identity();
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return Set.of(Collector.Characteristics.IDENTITY_FINISH);
        }
    }
}

