/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.type;

import it.unive.lisa.type.BooleanType;
import it.unive.lisa.type.NumericType;
import it.unive.lisa.type.StringType;
import it.unive.lisa.type.Type;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public abstract class TypeSystem {
    private final Map<String, Type> types = new TreeMap<String, Type>();

    protected TypeSystem() {
    }

    public Set<Type> getTypes() {
        return new HashSet<Type>(this.types.values());
    }

    public Type getType(String name) {
        return this.types.get(name);
    }

    public final boolean registerType(Type type) {
        return this.types.putIfAbsent(type.toString(), type) == null;
    }

    public Set<Type> cast(Set<Type> types, Set<Type> tokens) {
        return this.cast(types, tokens, null);
    }

    public Set<Type> cast(Set<Type> types, Set<Type> tokens, AtomicBoolean mightFail) {
        if (mightFail != null) {
            mightFail.set(false);
        }
        HashSet<Type> result = new HashSet<Type>();
        Set filtered = tokens.stream().filter(Type::isTypeTokenType).flatMap(t -> t.asTypeTokenType().getTypes().stream()).collect(Collectors.toSet());
        for (Type token : filtered) {
            for (Type t2 : types) {
                if (t2.canBeAssignedTo(token)) {
                    result.add(t2);
                    continue;
                }
                if (mightFail == null) continue;
                mightFail.set(true);
            }
        }
        return result;
    }

    public Set<Type> convert(Set<Type> types, Set<Type> tokens) {
        HashSet<Type> result = new HashSet<Type>();
        Set filtered = tokens.stream().filter(Type::isTypeTokenType).flatMap(t -> t.asTypeTokenType().getTypes().stream()).collect(Collectors.toSet());
        for (Type token : filtered) {
            for (Type t2 : types) {
                if (!t2.canBeAssignedTo(token)) continue;
                result.add(token);
            }
        }
        return result;
    }

    public abstract BooleanType getBooleanType();

    public abstract StringType getStringType();

    public abstract NumericType getIntegerType();

    public abstract boolean canBeReferenced(Type var1);
}

