/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.type;

import it.unive.lisa.type.PointerType;
import it.unive.lisa.type.Type;
import it.unive.lisa.type.TypeSystem;
import it.unive.lisa.type.Untyped;
import java.util.HashSet;
import java.util.Set;

public class ReferenceType
implements PointerType {
    private final Type innerType;

    public ReferenceType(Type t) {
        this.innerType = t;
    }

    @Override
    public boolean canBeAssignedTo(Type other) {
        return other instanceof ReferenceType && this.getInnerType().canBeAssignedTo(other.asReferenceType().getInnerType()) || other.isUntyped();
    }

    @Override
    public Type commonSupertype(Type other) {
        if (this.equals(other)) {
            return this;
        }
        if (other instanceof ReferenceType) {
            return new ReferenceType(this.getInnerType().commonSupertype(other.asReferenceType().getInnerType()));
        }
        return Untyped.INSTANCE;
    }

    @Override
    public Set<Type> allInstances(TypeSystem types) {
        HashSet<Type> instances = new HashSet<Type>();
        for (Type inner : this.getInnerType().allInstances(types)) {
            instances.add(new ReferenceType(inner));
        }
        instances.add(this);
        return instances;
    }

    @Override
    public Type getInnerType() {
        return this.innerType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.innerType == null ? 0 : this.innerType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReferenceType other = (ReferenceType)obj;
        return !(this.innerType == null ? other.innerType != null : !this.innerType.equals(other.innerType));
    }

    public String toString() {
        return this.innerType + "*";
    }
}

