/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.type;

import it.unive.lisa.type.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public interface NumericType
extends Type {
    public boolean is8Bits();

    public boolean is16Bits();

    public boolean is32Bits();

    public boolean is64Bits();

    public boolean isUnsigned();

    public boolean isIntegral();

    default public boolean isSigned() {
        return !this.isUnsigned();
    }

    default public boolean sameNumericTypes(NumericType other) {
        if (this.is8Bits() != other.is8Bits()) {
            return false;
        }
        if (this.is16Bits() != other.is16Bits()) {
            return false;
        }
        if (this.is32Bits() != other.is32Bits()) {
            return false;
        }
        if (this.is64Bits() != other.is64Bits()) {
            return false;
        }
        if (this.isIntegral() != other.isIntegral()) {
            return false;
        }
        return this.isUnsigned() == other.isUnsigned();
    }

    default public NumericType supertype(NumericType other) {
        if (this.is8Bits() && (other.is16Bits() || other.is32Bits() || other.is64Bits())) {
            return other;
        }
        if (other.is8Bits() && (this.is16Bits() || this.is32Bits() || this.is64Bits())) {
            return this;
        }
        if (this.is16Bits() && (other.is32Bits() || other.is64Bits())) {
            return other;
        }
        if (other.is16Bits() && (this.is32Bits() || this.is64Bits())) {
            return this;
        }
        if (this.is32Bits() && other.is64Bits()) {
            return other;
        }
        if (other.is32Bits() && this.is64Bits()) {
            return this;
        }
        if (this.isIntegral() && !other.isIntegral()) {
            return other;
        }
        if (!this.isIntegral() && other.isIntegral()) {
            return this;
        }
        if (this.isUnsigned() && other.isSigned()) {
            return other;
        }
        if (this.isSigned() && other.isUnsigned()) {
            return this;
        }
        return this;
    }

    public static Set<Type> commonNumericalType(Set<Type> left, Set<Type> right) {
        Set lfiltered = left.stream().filter(type -> type.isNumericType() || type.isUntyped()).collect(Collectors.toSet());
        Set rfiltered = right.stream().filter(type -> type.isNumericType() || type.isUntyped()).collect(Collectors.toSet());
        if ((lfiltered.isEmpty() || lfiltered.stream().allMatch(Type::isUntyped)) && (rfiltered.isEmpty() || rfiltered.stream().allMatch(Type::isUntyped))) {
            return Collections.emptySet();
        }
        HashSet<Type> result = new HashSet<Type>();
        for (Type t1 : lfiltered) {
            for (Type t2 : rfiltered) {
                if (t1.isUntyped() && t2.isUntyped()) {
                    result.add(t1);
                    continue;
                }
                if (t1.isUntyped()) {
                    result.add(t2);
                    continue;
                }
                if (t2.isUntyped()) {
                    result.add(t1);
                    continue;
                }
                result.add(t1.commonSupertype(t2));
            }
        }
        return result;
    }
}

