/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.symbolic.value;

import it.unive.lisa.analysis.ScopeToken;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.symbolic.ExpressionVisitor;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.value.BinaryExpression;
import it.unive.lisa.symbolic.value.ValueExpression;
import it.unive.lisa.symbolic.value.operator.NegatableOperator;
import it.unive.lisa.symbolic.value.operator.binary.BinaryOperator;
import it.unive.lisa.symbolic.value.operator.unary.LogicalNegation;
import it.unive.lisa.symbolic.value.operator.unary.UnaryOperator;
import it.unive.lisa.type.Type;

public class UnaryExpression
extends ValueExpression {
    private final SymbolicExpression expression;
    private final UnaryOperator operator;

    public UnaryExpression(Type staticType, SymbolicExpression expression, UnaryOperator operator, CodeLocation location) {
        super(staticType, location);
        this.expression = expression;
        this.operator = operator;
    }

    public SymbolicExpression getExpression() {
        return this.expression;
    }

    public UnaryOperator getOperator() {
        return this.operator;
    }

    @Override
    public ValueExpression removeNegations() {
        if (this.operator instanceof LogicalNegation && this.expression instanceof BinaryExpression) {
            BinaryExpression binary = (BinaryExpression)this.expression;
            ValueExpression left = (ValueExpression)binary.getLeft();
            ValueExpression right = (ValueExpression)binary.getRight();
            BinaryOperator op = binary.getOperator();
            BinaryOperator oppositeOp = op instanceof NegatableOperator ? (BinaryOperator)((Object)((NegatableOperator)((Object)op)).opposite()) : op;
            BinaryExpression expr = new BinaryExpression(binary.getStaticType(), left.removeNegations(), right.removeNegations(), oppositeOp, this.getCodeLocation());
            return expr;
        }
        return this;
    }

    @Override
    public SymbolicExpression pushScope(ScopeToken token) throws SemanticException {
        UnaryExpression expr = new UnaryExpression(this.getStaticType(), this.expression.pushScope(token), this.operator, this.getCodeLocation());
        return expr;
    }

    @Override
    public SymbolicExpression popScope(ScopeToken token) throws SemanticException {
        UnaryExpression expr = new UnaryExpression(this.getStaticType(), this.expression.popScope(token), this.operator, this.getCodeLocation());
        return expr;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.expression == null ? 0 : this.expression.hashCode());
        result = 31 * result + (this.operator == null ? 0 : this.operator.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UnaryExpression other = (UnaryExpression)obj;
        if (this.expression == null ? other.expression != null : !this.expression.equals(other.expression)) {
            return false;
        }
        return this.operator == other.operator;
    }

    @Override
    public String toString() {
        return this.operator + " " + this.expression;
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor, Object ... params) throws SemanticException {
        T arg = this.expression.accept(visitor, params);
        return visitor.visit(this, arg, params);
    }

    @Override
    public boolean mightNeedRewriting() {
        return this.expression.mightNeedRewriting();
    }
}

