/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.symbolic.value;

import it.unive.lisa.analysis.ScopeToken;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.symbolic.ExpressionVisitor;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.value.ValueExpression;
import it.unive.lisa.symbolic.value.operator.ternary.TernaryOperator;
import it.unive.lisa.type.Type;

public class TernaryExpression
extends ValueExpression {
    private final SymbolicExpression left;
    private final SymbolicExpression middle;
    private final SymbolicExpression right;
    private final TernaryOperator operator;

    public TernaryExpression(Type staticType, SymbolicExpression left, SymbolicExpression middle, SymbolicExpression right, TernaryOperator operator, CodeLocation location) {
        super(staticType, location);
        this.left = left;
        this.middle = middle;
        this.right = right;
        this.operator = operator;
    }

    public SymbolicExpression getLeft() {
        return this.left;
    }

    public SymbolicExpression getMiddle() {
        return this.middle;
    }

    public SymbolicExpression getRight() {
        return this.right;
    }

    public TernaryOperator getOperator() {
        return this.operator;
    }

    @Override
    public SymbolicExpression pushScope(ScopeToken token) throws SemanticException {
        TernaryExpression expr = new TernaryExpression(this.getStaticType(), this.left.pushScope(token), this.middle.pushScope(token), this.right.pushScope(token), this.operator, this.getCodeLocation());
        return expr;
    }

    @Override
    public SymbolicExpression popScope(ScopeToken token) throws SemanticException {
        TernaryExpression expr = new TernaryExpression(this.getStaticType(), this.left.popScope(token), this.middle.popScope(token), this.right.popScope(token), this.operator, this.getCodeLocation());
        return expr;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.left == null ? 0 : this.left.hashCode());
        result = 31 * result + (this.operator == null ? 0 : this.operator.hashCode());
        result = 31 * result + (this.right == null ? 0 : this.right.hashCode());
        result = 31 * result + (this.middle == null ? 0 : this.middle.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TernaryExpression other = (TernaryExpression)obj;
        if (this.left == null ? other.left != null : !this.left.equals(other.left)) {
            return false;
        }
        if (this.operator != other.operator) {
            return false;
        }
        if (this.middle == null ? other.middle != null : !this.middle.equals(other.middle)) {
            return false;
        }
        return !(this.right == null ? other.right != null : !this.right.equals(other.right));
    }

    @Override
    public String toString() {
        return this.left + " " + this.operator + "(" + this.middle + ", " + this.right + ")";
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor, Object ... params) throws SemanticException {
        T left = this.left.accept(visitor, params);
        T middle = this.middle.accept(visitor, params);
        T right = this.right.accept(visitor, params);
        return visitor.visit(this, left, middle, right, params);
    }

    @Override
    public boolean mightNeedRewriting() {
        return this.left.mightNeedRewriting() || this.middle.mightNeedRewriting() || this.right.mightNeedRewriting();
    }
}

