/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.symbolic.value;

import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.program.annotations.Annotation;
import it.unive.lisa.program.annotations.Annotations;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.symbolic.value.ValueExpression;
import it.unive.lisa.type.Type;

public abstract class Identifier
extends ValueExpression {
    private final String name;
    private final boolean weak;
    private final Annotations annotations;

    protected Identifier(Type staticType, String name, boolean weak, Annotations annotations, CodeLocation location) {
        super(staticType, location);
        this.name = name;
        this.weak = weak;
        this.annotations = annotations;
    }

    public String getName() {
        return this.name;
    }

    public boolean isWeak() {
        return this.weak;
    }

    public boolean isScopedByCall() {
        return false;
    }

    public abstract boolean canBeScoped();

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Identifier other = (Identifier)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public Annotations getAnnotations() {
        return this.annotations;
    }

    public void addAnnotation(Annotation ann) {
        this.annotations.addAnnotation(ann);
    }

    public Identifier lub(Identifier other) throws SemanticException {
        if (!this.equals(other)) {
            throw new SemanticException("Cannot perform the least upper bound between different identifiers: '" + this + "' and '" + other + "'");
        }
        return this;
    }

    @Override
    public boolean mightNeedRewriting() {
        Type t = this.getStaticType();
        return !t.isValueType() || t.isUntyped();
    }
}

