/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.symbolic.value;

import it.unive.lisa.analysis.ScopeToken;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.program.annotations.Annotation;
import it.unive.lisa.program.annotations.Annotations;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.symbolic.ExpressionVisitor;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.type.Type;

public class HeapLocation
extends Identifier {
    public HeapLocation(Type staticType, String name, boolean weak, CodeLocation location) {
        super(staticType, name, weak, new Annotations(new Annotation[0]), location);
    }

    @Override
    public String toString() {
        return "heap[" + (this.isWeak() ? "w" : "s") + "]:" + this.getName();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.isWeak() ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HeapLocation other = (HeapLocation)obj;
        return this.isWeak() == other.isWeak();
    }

    @Override
    public Identifier lub(Identifier other) throws SemanticException {
        if (!this.getName().equals(other.getName())) {
            throw new SemanticException("Cannot perform the least upper bound between different identifiers: '" + this + "' and '" + other + "'");
        }
        return this.isWeak() ? this : other;
    }

    @Override
    public boolean canBeScoped() {
        return false;
    }

    @Override
    public SymbolicExpression pushScope(ScopeToken token) {
        return this;
    }

    @Override
    public SymbolicExpression popScope(ScopeToken token) throws SemanticException {
        return this;
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor, Object ... params) throws SemanticException {
        return visitor.visit(this, params);
    }
}

