/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.symbolic.heap;

import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.program.annotations.Annotation;
import it.unive.lisa.program.annotations.Annotations;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.symbolic.ExpressionVisitor;
import it.unive.lisa.symbolic.heap.HeapExpression;
import it.unive.lisa.type.Type;
import java.util.Objects;

public class MemoryAllocation
extends HeapExpression {
    private final boolean isStackAllocation;
    private final Annotations anns;

    public MemoryAllocation(Type staticType, CodeLocation location) {
        this(staticType, location, false);
    }

    public MemoryAllocation(Type staticType, CodeLocation location, Annotations anns) {
        this(staticType, location, anns, false);
    }

    public MemoryAllocation(Type staticType, CodeLocation location, boolean isStackAllocation) {
        this(staticType, location, new Annotations(new Annotation[0]), isStackAllocation);
    }

    public MemoryAllocation(Type staticType, CodeLocation location, Annotations anns, boolean isStackAllocation) {
        super(staticType, location);
        this.isStackAllocation = isStackAllocation;
        this.anns = anns;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.anns, this.isStackAllocation);
        return result;
    }

    public boolean isStackAllocation() {
        return this.isStackAllocation;
    }

    public Annotations getAnnotations() {
        return this.anns;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MemoryAllocation other = (MemoryAllocation)obj;
        return Objects.equals(this.anns, other.anns) && this.isStackAllocation == other.isStackAllocation;
    }

    @Override
    public String toString() {
        return (this.isStackAllocation ? "" : "new ") + this.getStaticType();
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor, Object ... params) throws SemanticException {
        return visitor.visit(this, params);
    }
}

