/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program.language.validation;

import it.unive.lisa.program.AbstractClassUnit;
import it.unive.lisa.program.ClassUnit;
import it.unive.lisa.program.CodeUnit;
import it.unive.lisa.program.CompilationUnit;
import it.unive.lisa.program.ConstantGlobal;
import it.unive.lisa.program.Global;
import it.unive.lisa.program.InterfaceUnit;
import it.unive.lisa.program.Program;
import it.unive.lisa.program.ProgramValidationException;
import it.unive.lisa.program.Unit;
import it.unive.lisa.program.annotations.Annotation;
import it.unive.lisa.program.cfg.AbstractCodeMember;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.CodeMember;
import it.unive.lisa.program.cfg.Parameter;
import it.unive.lisa.program.language.validation.ProgramValidationLogic;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;

public class BaseValidationLogic
implements ProgramValidationLogic {
    public static final String DUPLICATE_MEMBER = "%s is duplicated within unit %s";
    public static final String INVALID_NODE_LIST = "The node list behind %s is invalid";
    public static final String INVALID_CFSTRUCTURE = "%s has a conditional structure (%s) that contains a node not in the graph: %s";
    public static final String EXIT_WITH_FOLLOWERS = "%s contains an execution-stopping node that has followers: %s";
    public static final String NO_FOLLOWERS = "%s contains a node with no followers that is not execution-stopping: %s";
    public static final String UNKNOWN_ENTRYPOINTS = "Program contains entrypoints that are not part of the program: %s";
    public static final String INTERFACE_WITH_GLOBALS = "%s is an interface and cannot have instange globals";
    public static final String ABSTRACT_SEALED_UNIT = "%s is abstract and cannot be sealed";
    public static final String ABSTRACT_METHODS = "%s is not abstract and cannot have abstract code members";
    public static final String INHERIT_FROM_SEALED = "%s cannot inherit from the sealed unit %s";
    public static final String MISSING_OVERRIDE = "%s does not override %s from the non-instantiable unit %s";
    public static final String CANNOT_OVERRIDE = "%s overrides the non-overridable member %s";
    public static final String MULTIPLE_OVERRIDES = "%s is overriden multiple times in unit %s: %s";
    public static final String ABSTRACT_NON_INSTANCE = "%s is not an instance member and cannot be abstract";
    public static final String MEMBER_MISMATCH = "%s does not match its own signature";
    public static final String GLOBAL_INSTANCE_MISMATCH = "%s has a mismatched instance flag (%s, while being %s)";
    public static final String CONST_INSTANCE_GLOBAL = "%s is a constant global and cannot be declared as instance";
    public final Set<String> processedUnits = new TreeSet<String>();

    @Override
    public void validateAndFinalize(Program program) throws ProgramValidationException {
        this.validateAndFinalize((Unit)program);
        Collection<CFG> baseline = program.getAllCFGs();
        Collection<CFG> entrypoints = program.getEntryPoints();
        if (!baseline.containsAll(entrypoints)) {
            HashSet<CFG> diff = new HashSet<CFG>(entrypoints);
            diff.retainAll(baseline);
            throw new ProgramValidationException(String.format(UNKNOWN_ENTRYPOINTS, diff));
        }
        for (Unit unit : program.getUnits()) {
            this.validateAndFinalize(unit);
        }
    }

    public void validateAndFinalize(Unit unit) throws ProgramValidationException {
        for (CodeMember member : unit.getCodeMembers()) {
            this.validate(member, false);
        }
        for (Global global : unit.getGlobals()) {
            this.validate(global, false);
        }
        if (unit instanceof CodeUnit) {
            this.validateAndFinalize((CodeUnit)unit);
        } else if (unit instanceof AbstractClassUnit) {
            this.validateAndFinalize((AbstractClassUnit)unit);
        } else if (unit instanceof ClassUnit) {
            this.validateAndFinalize((ClassUnit)unit);
        } else if (unit instanceof InterfaceUnit) {
            this.validateAndFinalize((InterfaceUnit)unit);
        }
    }

    public void validate(Global global, boolean isInstance) throws ProgramValidationException {
        if (isInstance != global.isInstance()) {
            throw new ProgramValidationException(String.format(GLOBAL_INSTANCE_MISMATCH, global, global.isInstance(), isInstance ? "instance" : "non-instance"));
        }
        if (isInstance && global instanceof ConstantGlobal) {
            throw new ProgramValidationException(String.format(CONST_INSTANCE_GLOBAL, global));
        }
    }

    public void validateAndFinalize(CodeUnit unit) throws ProgramValidationException {
    }

    public void validateAndFinalize(ClassUnit unit) throws ProgramValidationException {
        if (this.processedUnits.contains(unit.getName())) {
            return;
        }
        if (unit.canBeInstantiated() && !unit.searchCodeMembers(cm -> cm instanceof AbstractCodeMember, false).isEmpty()) {
            throw new ProgramValidationException(String.format(ABSTRACT_METHODS, unit));
        }
        this.validateAndFinalize((CompilationUnit)unit);
    }

    public void validateAndFinalize(AbstractClassUnit unit) throws ProgramValidationException {
        if (this.processedUnits.contains(unit.getName())) {
            return;
        }
        if (unit.isSealed()) {
            throw new ProgramValidationException(String.format(ABSTRACT_SEALED_UNIT, unit));
        }
        this.validateAndFinalize((ClassUnit)unit);
    }

    public void validateAndFinalize(InterfaceUnit unit) throws ProgramValidationException {
        if (this.processedUnits.contains(unit.getName())) {
            return;
        }
        if (!unit.getInstanceGlobals(false).isEmpty()) {
            throw new ProgramValidationException(String.format(INTERFACE_WITH_GLOBALS, unit));
        }
        this.validateAndFinalize((CompilationUnit)unit);
    }

    public void validateAndFinalize(CompilationUnit unit) throws ProgramValidationException {
        if (this.processedUnits.contains(unit.getName())) {
            return;
        }
        for (CompilationUnit sup : unit.getImmediateAncestors()) {
            if (sup.isSealed()) {
                throw new ProgramValidationException(String.format(INHERIT_FROM_SEALED, unit, sup));
            }
            this.validateAndFinalize(sup);
        }
        for (CodeMember cm : unit.getInstanceCodeMembers(false)) {
            this.validate(cm, true);
        }
        for (Global global : unit.getInstanceGlobals(false)) {
            this.validate(global, true);
        }
        unit.addInstance(unit);
        for (CompilationUnit ancestor : unit.getImmediateAncestors()) {
            for (CodeMember inherited : ancestor.getInstanceCodeMembers(true)) {
                Collection<CodeMember> localOverrides = unit.getMatchingInstanceCodeMembers(inherited.getDescriptor(), false);
                if (localOverrides.isEmpty()) {
                    if (!(inherited instanceof AbstractCodeMember) || ancestor.canBeInstantiated() || !unit.canBeInstantiated()) continue;
                    throw new ProgramValidationException(String.format(MISSING_OVERRIDE, unit, inherited.getDescriptor().getSignature(), ancestor));
                }
                if (localOverrides.size() == 1) {
                    if (!inherited.getDescriptor().isOverridable()) {
                        throw new ProgramValidationException(String.format(CANNOT_OVERRIDE, unit, inherited.getDescriptor().getSignature()));
                    }
                    CodeMember over = localOverrides.iterator().next();
                    over.getDescriptor().overrides().addAll(inherited.getDescriptor().overrides());
                    over.getDescriptor().overrides().add(inherited);
                    over.getDescriptor().overrides().forEach(c -> c.getDescriptor().overriddenBy().add(over));
                    continue;
                }
                throw new ProgramValidationException(String.format(MULTIPLE_OVERRIDES, inherited.getDescriptor().getSignature(), unit, StringUtils.join((Object[])new Object[]{", ", localOverrides})));
            }
            for (Annotation ann : ancestor.getAnnotations()) {
                if (ann.isInherited()) continue;
                unit.addAnnotation(ann);
            }
        }
        for (CodeMember instCfg : unit.getInstanceCodeMembers(false)) {
            for (CodeMember matching : instCfg.getDescriptor().overrides()) {
                for (Annotation ann : matching.getDescriptor().getAnnotations()) {
                    if (!ann.isInherited()) {
                        instCfg.getDescriptor().addAnnotation(ann);
                    }
                    Parameter[] args = instCfg.getDescriptor().getFormals();
                    Parameter[] superArgs = matching.getDescriptor().getFormals();
                    for (int i = 0; i < args.length; ++i) {
                        for (Annotation parAnn : superArgs[i].getAnnotations()) {
                            if (parAnn.isInherited()) continue;
                            args[i].addAnnotation(parAnn);
                        }
                    }
                }
            }
        }
        this.processedUnits.add(unit.getName());
    }

    public void validate(CodeMember member, boolean instance) throws ProgramValidationException {
        Collection<CodeMember> matching;
        if (!instance && member instanceof AbstractCodeMember) {
            throw new ProgramValidationException(String.format(ABSTRACT_NON_INSTANCE, member));
        }
        Unit container = member.getDescriptor().getUnit();
        Collection<CodeMember> collection = matching = instance ? ((CompilationUnit)container).getMatchingInstanceCodeMembers(member.getDescriptor(), false) : container.getMatchingCodeMember(member.getDescriptor());
        if (matching.isEmpty()) {
            throw new ProgramValidationException(String.format(MEMBER_MISMATCH, member.getDescriptor().getSignature()));
        }
        if (matching.size() != 1 || matching.iterator().next() != member) {
            throw new ProgramValidationException(String.format(DUPLICATE_MEMBER, member.getDescriptor().getSignature(), container));
        }
        member.validate();
    }
}

