/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program.language.parameterassignment;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.AnalysisState;
import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.SemanticOracle;
import it.unive.lisa.analysis.StatementStore;
import it.unive.lisa.analysis.lattices.ExpressionSet;
import it.unive.lisa.interprocedural.InterproceduralAnalysis;
import it.unive.lisa.program.cfg.Parameter;
import it.unive.lisa.program.cfg.statement.Expression;
import it.unive.lisa.program.cfg.statement.call.Call;
import it.unive.lisa.program.language.parameterassignment.ParameterAssigningStrategy;
import it.unive.lisa.program.language.resolution.PythonLikeMatchingStrategy;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.type.Type;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;

public class PythonLikeAssigningStrategy
implements ParameterAssigningStrategy {
    public static final PythonLikeAssigningStrategy INSTANCE = new PythonLikeAssigningStrategy();

    private PythonLikeAssigningStrategy() {
    }

    @Override
    public <A extends AbstractState<A>> Pair<AnalysisState<A>, ExpressionSet[]> prepare(Call call, AnalysisState<A> callState, InterproceduralAnalysis<A> interprocedural, StatementStore<A> expressions, Parameter[] formals, ExpressionSet[] parameters) throws SemanticException {
        ExpressionSet[] slots = new ExpressionSet[formals.length];
        Set[] slotsTypes = new Set[formals.length];
        Expression[] actuals = call.getParameters();
        ExpressionSet[] defaults = new ExpressionSet[formals.length];
        Set[] defaultTypes = new Set[formals.length];
        for (int pos = 0; pos < slots.length; ++pos) {
            Expression def = formals[pos].getDefaultValue();
            if (def == null) continue;
            callState = def.forwardSemantics(callState, interprocedural, expressions);
            expressions.put(def, callState);
            defaults[pos] = callState.getComputedExpressions();
            HashSet<Type> types = new HashSet<Type>();
            for (SymbolicExpression e : defaults[pos]) {
                types.addAll(callState.getState().getRuntimeTypesOf(e, call, (SemanticOracle)callState.getState()));
            }
            defaultTypes[pos] = types;
        }
        AnalysisState logic = (AnalysisState)PythonLikeMatchingStrategy.pythonLogic(formals, actuals, parameters, call.parameterTypes(expressions), defaults, defaultTypes, slots, slotsTypes, callState.bottom());
        if (logic != null) {
            return Pair.of((Object)logic, (Object)parameters);
        }
        Lattice<AnalysisState<A>> prepared = callState;
        for (int i = 0; i < formals.length; ++i) {
            AnalysisState temp = ((AnalysisState)prepared).bottom();
            for (SymbolicExpression exp : slots[i]) {
                temp = temp.lub(((AnalysisState)prepared).assign(formals[i].toSymbolicVariable(), exp, call));
            }
            prepared = temp;
        }
        prepared = new AnalysisState<A>(((AnalysisState)prepared).getState(), new ExpressionSet(), ((AnalysisState)prepared).getFixpointInformation());
        return Pair.of(prepared, (Object)slots);
    }
}

