/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program.cfg.statement.call;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.AnalysisState;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.StatementStore;
import it.unive.lisa.analysis.lattices.ExpressionSet;
import it.unive.lisa.interprocedural.InterproceduralAnalysis;
import it.unive.lisa.program.cfg.CodeMember;
import it.unive.lisa.program.cfg.statement.Expression;
import it.unive.lisa.program.cfg.statement.call.Call;
import it.unive.lisa.program.cfg.statement.call.ResolvedCall;
import it.unive.lisa.program.cfg.statement.call.UnresolvedCall;
import java.util.Collection;

public class TruncatedParamsCall
extends Call
implements ResolvedCall {
    private final Call call;

    public TruncatedParamsCall(Call call) {
        super(call.getCFG(), call.getLocation(), call.getCallType(), call.getQualifier(), call.getTargetName(), call.getOrder(), call.getStaticType(), call.getParameters());
        if (!(call instanceof ResolvedCall)) {
            throw new IllegalArgumentException("The given call has not been resolved yet");
        }
        this.call = call;
    }

    @Override
    public void setSource(UnresolvedCall source) {
        super.setSource(source);
        this.call.setSource(source);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.call == null ? 0 : this.call.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TruncatedParamsCall other = (TruncatedParamsCall)obj;
        return !(this.call == null ? other.call != null : !this.call.equals(other.call));
    }

    @Override
    protected int compareCallAux(Call o) {
        return this.call.compareCallAux(((TruncatedParamsCall)o).call);
    }

    @Override
    public <A extends AbstractState<A>> AnalysisState<A> forwardSemanticsAux(InterproceduralAnalysis<A> interprocedural, AnalysisState<A> state, ExpressionSet[] params, StatementStore<A> expressions) throws SemanticException {
        AnalysisState<A> post;
        Expression[] actuals = this.getParameters();
        if (params.length == actuals.length) {
            post = this.call.forwardSemanticsAux(interprocedural, state, params, expressions);
        } else {
            ExpressionSet[] truncatedParams = new ExpressionSet[actuals.length];
            if (actuals.length > 0) {
                System.arraycopy(params, 1, truncatedParams, 0, params.length - 1);
            }
            post = this.call.forwardSemanticsAux(interprocedural, state, truncatedParams, expressions);
        }
        this.getMetaVariables().addAll(this.call.getMetaVariables());
        return post;
    }

    @Override
    public Collection<CodeMember> getTargets() {
        return ((ResolvedCall)((Object)this.call)).getTargets();
    }

    public Call getInnerCall() {
        return this.call;
    }
}

