/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program.cfg.statement.call;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.AnalysisState;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.StatementStore;
import it.unive.lisa.analysis.lattices.ExpressionSet;
import it.unive.lisa.interprocedural.InterproceduralAnalysis;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.program.cfg.CodeMember;
import it.unive.lisa.program.cfg.statement.Expression;
import it.unive.lisa.program.cfg.statement.call.Call;
import it.unive.lisa.program.cfg.statement.call.CallWithResult;
import it.unive.lisa.program.cfg.statement.call.UnresolvedCall;
import it.unive.lisa.program.cfg.statement.evaluation.EvaluationOrder;
import it.unive.lisa.program.cfg.statement.evaluation.LeftToRightEvaluation;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.Variable;
import it.unive.lisa.type.Type;
import it.unive.lisa.type.Untyped;
import java.util.Collection;
import java.util.Collections;

public class OpenCall
extends CallWithResult {
    public OpenCall(CFG cfg, CodeLocation location, Call.CallType callType, String qualifier, String targetName, Expression ... parameters) {
        super(cfg, location, callType, qualifier, targetName, LeftToRightEvaluation.INSTANCE, Untyped.INSTANCE, parameters);
    }

    public OpenCall(CFG cfg, CodeLocation location, Call.CallType callType, String qualifier, String targetName, EvaluationOrder order, Expression ... parameters) {
        super(cfg, location, callType, qualifier, targetName, order, Untyped.INSTANCE, parameters);
    }

    public OpenCall(CFG cfg, CodeLocation location, Call.CallType callType, String qualifier, String targetName, Type staticType, Expression ... parameters) {
        this(cfg, location, callType, qualifier, targetName, (EvaluationOrder)LeftToRightEvaluation.INSTANCE, staticType, parameters);
    }

    public OpenCall(CFG cfg, CodeLocation location, Call.CallType callType, String qualifier, String targetName, EvaluationOrder order, Type staticType, Expression ... parameters) {
        super(cfg, location, callType, qualifier, targetName, order, staticType, parameters);
    }

    public OpenCall(UnresolvedCall source) {
        this(source.getCFG(), source.getLocation(), source.getCallType(), source.getQualifier(), source.getTargetName(), source.getOrder(), source.getStaticType(), source.getParameters());
        for (Expression param : source.getParameters()) {
            param.setParentStatement(source);
        }
    }

    @Override
    protected int compareCallAux(Call o) {
        return 0;
    }

    @Override
    public String toString() {
        return "[open] " + super.toString();
    }

    @Override
    public final Identifier getMetaVariable() {
        return new Variable(this.getStaticType(), "open_call_ret_value@" + this.getLocation(), this.getLocation());
    }

    @Override
    public <A extends AbstractState<A>> AnalysisState<A> compute(AnalysisState<A> entryState, InterproceduralAnalysis<A> interprocedural, StatementStore<A> expressions, ExpressionSet[] parameters) throws SemanticException {
        return interprocedural.getAbstractResultOf(this, entryState, parameters, expressions);
    }

    @Override
    public Collection<CodeMember> getTargets() {
        return Collections.emptySet();
    }
}

