/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program.cfg.statement.call;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.AnalysisState;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.StatementStore;
import it.unive.lisa.analysis.lattices.ExpressionSet;
import it.unive.lisa.interprocedural.InterproceduralAnalysis;
import it.unive.lisa.program.cfg.CodeMember;
import it.unive.lisa.program.cfg.statement.Statement;
import it.unive.lisa.program.cfg.statement.call.Call;
import it.unive.lisa.program.cfg.statement.call.ResolvedCall;
import it.unive.lisa.program.cfg.statement.call.UnresolvedCall;
import it.unive.lisa.type.Type;
import it.unive.lisa.type.Untyped;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class MultiCall
extends Call
implements ResolvedCall {
    private final Collection<Call> calls;

    public MultiCall(UnresolvedCall source, Call ... calls) {
        super(source.getCFG(), source.getLocation(), source.getCallType(), source.getQualifier(), source.getTargetName(), source.getOrder(), MultiCall.getCommonReturnType(calls), source.getParameters());
        Objects.requireNonNull(calls, "The calls underlying a multi call cannot be null");
        for (Call target : calls) {
            Objects.requireNonNull(target, "A call underlying a multi call cannot be null");
            if (target instanceof ResolvedCall) continue;
            throw new IllegalArgumentException(target + " has not been resolved yet");
        }
        this.calls = List.of(calls);
    }

    private static Type getCommonReturnType(Call ... targets) {
        Type result = null;
        for (Call c : targets) {
            Type current = c.getStaticType();
            if (result == null) {
                result = current;
            } else {
                if (current.canBeAssignedTo(result)) continue;
                result = result.canBeAssignedTo(current) ? current : result.commonSupertype(current);
            }
            if (current.isUntyped()) break;
        }
        return result == null ? Untyped.INSTANCE : result;
    }

    public Collection<Call> getCalls() {
        return this.calls;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.calls == null ? 0 : this.calls.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MultiCall other = (MultiCall)obj;
        return !(this.calls == null ? other.calls != null : !this.calls.equals(other.calls));
    }

    @Override
    protected int compareCallAux(Call o) {
        MultiCall other = (MultiCall)o;
        int cmp = Integer.compare(this.calls.size(), other.calls.size());
        if (cmp != 0) {
            return cmp;
        }
        LinkedList<Call> l1 = new LinkedList<Call>(this.calls);
        LinkedList<Call> l2 = new LinkedList<Call>(other.calls);
        for (int i = 0; i < l1.size(); ++i) {
            cmp = ((Call)l1.get(i)).compareTo((Statement)l2.get(i));
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    @Override
    public String toString() {
        return "[multi] " + super.toString();
    }

    @Override
    public void setSource(UnresolvedCall source) {
        super.setSource(source);
        this.calls.forEach(c -> c.setSource(source));
    }

    @Override
    public <A extends AbstractState<A>> AnalysisState<A> forwardSemanticsAux(InterproceduralAnalysis<A> interprocedural, AnalysisState<A> state, ExpressionSet[] params, StatementStore<A> expressions) throws SemanticException {
        AnalysisState<A> result = state.bottom();
        for (Call call : this.calls) {
            result = result.lub(call.forwardSemanticsAux(interprocedural, state, params, expressions));
            this.getMetaVariables().addAll(call.getMetaVariables());
        }
        return result;
    }

    @Override
    public Collection<CodeMember> getTargets() {
        return this.calls.stream().map(ResolvedCall.class::cast).flatMap(c -> c.getTargets().stream()).collect(Collectors.toSet());
    }
}

