/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program.cfg.statement.call;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.AnalysisState;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.SemanticOracle;
import it.unive.lisa.analysis.StatementStore;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.program.cfg.statement.Expression;
import it.unive.lisa.program.cfg.statement.NaryExpression;
import it.unive.lisa.program.cfg.statement.Statement;
import it.unive.lisa.program.cfg.statement.call.UnresolvedCall;
import it.unive.lisa.program.cfg.statement.evaluation.EvaluationOrder;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.type.Type;
import it.unive.lisa.util.collections.CollectionUtilities;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public abstract class Call
extends NaryExpression {
    private UnresolvedCall source = null;
    private final String qualifier;
    private final String targetName;
    private final CallType callType;

    protected Call(CFG cfg, CodeLocation location, CallType type, String qualifier, String targetName, EvaluationOrder order, Type staticType, Expression ... parameters) {
        super(cfg, location, Call.completeName(qualifier, targetName), order, staticType, parameters);
        Objects.requireNonNull(targetName, "The name of the target of a call cannot be null");
        this.targetName = targetName;
        this.qualifier = qualifier;
        this.callType = type;
    }

    private static String completeName(String qualifier, String name) {
        return StringUtils.isNotBlank((CharSequence)qualifier) ? qualifier + "::" + name : name;
    }

    public final UnresolvedCall getSource() {
        return this.source;
    }

    public String getFullTargetName() {
        return this.getConstructName();
    }

    public String getTargetName() {
        return this.targetName;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public final Expression[] getParameters() {
        return this.getSubExpressions();
    }

    public CallType getCallType() {
        return this.callType;
    }

    public void setSource(UnresolvedCall source) {
        this.source = source;
    }

    @Override
    public String toString() {
        return this.getConstructName() + "(" + StringUtils.join((Object[])this.getParameters(), (String)", ") + ")";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.qualifier == null ? 0 : this.qualifier.hashCode());
        result = 31 * result + (this.targetName == null ? 0 : this.targetName.hashCode());
        result = 31 * result + (this.callType == null ? 0 : this.callType.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Call other = (Call)obj;
        if (this.qualifier == null ? other.qualifier != null : !this.qualifier.equals(other.qualifier)) {
            return false;
        }
        if (this.targetName == null ? other.targetName != null : !this.targetName.equals(other.targetName)) {
            return false;
        }
        return this.callType == other.callType;
    }

    @Override
    protected int compareSameClassAndParams(Statement o) {
        Call other = (Call)o;
        int cmp = this.targetName.compareTo(other.targetName);
        if (cmp != 0) {
            return cmp;
        }
        cmp = CollectionUtilities.nullSafeCompare(true, this.qualifier, other.qualifier, String::compareTo);
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.callType.compareTo(other.callType);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareCallAux(other);
    }

    protected abstract int compareCallAux(Call var1);

    public <A extends AbstractState<A>> Set<Type>[] parameterTypes(StatementStore<A> expressions) throws SemanticException {
        Expression[] actuals = this.getParameters();
        Set[] types = new Set[actuals.length];
        for (int i = 0; i < actuals.length; ++i) {
            AnalysisState state = (AnalysisState)expressions.getState(actuals[i]);
            HashSet<Type> t = new HashSet<Type>();
            for (SymbolicExpression e : state.getComputedExpressions()) {
                t.addAll(state.getState().getRuntimeTypesOf(e, this, (SemanticOracle)state.getState()));
            }
            types[i] = t;
        }
        return types;
    }

    public static enum CallType {
        INSTANCE,
        STATIC,
        UNKNOWN;

    }
}

