/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program.cfg.statement;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.AnalysisState;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.StatementStore;
import it.unive.lisa.analysis.lattices.ExpressionSet;
import it.unive.lisa.interprocedural.InterproceduralAnalysis;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.program.cfg.statement.Expression;
import it.unive.lisa.program.cfg.statement.NaryExpression;
import it.unive.lisa.program.cfg.statement.evaluation.EvaluationOrder;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.type.Type;

public abstract class TernaryExpression
extends NaryExpression {
    protected TernaryExpression(CFG cfg, CodeLocation location, String constructName, Expression left, Expression middle, Expression right) {
        super(cfg, location, constructName, left, middle, right);
    }

    protected TernaryExpression(CFG cfg, CodeLocation location, String constructName, Type staticType, Expression left, Expression middle, Expression right) {
        super(cfg, location, constructName, staticType, left, middle, right);
    }

    protected TernaryExpression(CFG cfg, CodeLocation location, String constructName, EvaluationOrder order, Expression left, Expression middle, Expression right) {
        super(cfg, location, constructName, order, left, middle, right);
    }

    protected TernaryExpression(CFG cfg, CodeLocation location, String constructName, EvaluationOrder order, Type staticType, Expression left, Expression middle, Expression right) {
        super(cfg, location, constructName, order, staticType, left, middle, right);
    }

    public Expression getLeft() {
        return this.getSubExpressions()[0];
    }

    public Expression getMiddle() {
        return this.getSubExpressions()[2];
    }

    public Expression getRight() {
        return this.getSubExpressions()[2];
    }

    @Override
    public <A extends AbstractState<A>> AnalysisState<A> forwardSemanticsAux(InterproceduralAnalysis<A> interprocedural, AnalysisState<A> state, ExpressionSet[] params, StatementStore<A> expressions) throws SemanticException {
        AnalysisState<A> result = state.bottom();
        for (SymbolicExpression left : params[0]) {
            for (SymbolicExpression middle : params[1]) {
                for (SymbolicExpression right : params[2]) {
                    result = result.lub(this.fwdTernarySemantics(interprocedural, state, left, middle, right, expressions));
                }
            }
        }
        return result;
    }

    public abstract <A extends AbstractState<A>> AnalysisState<A> fwdTernarySemantics(InterproceduralAnalysis<A> var1, AnalysisState<A> var2, SymbolicExpression var3, SymbolicExpression var4, SymbolicExpression var5, StatementStore<A> var6) throws SemanticException;

    @Override
    public <A extends AbstractState<A>> AnalysisState<A> backwardSemanticsAux(InterproceduralAnalysis<A> interprocedural, AnalysisState<A> state, ExpressionSet[] params, StatementStore<A> expressions) throws SemanticException {
        AnalysisState<A> result = state.bottom();
        for (SymbolicExpression left : params[0]) {
            for (SymbolicExpression middle : params[1]) {
                for (SymbolicExpression right : params[2]) {
                    result = result.lub(this.bwdTernarySemantics(interprocedural, state, left, middle, right, expressions));
                }
            }
        }
        return result;
    }

    public <A extends AbstractState<A>> AnalysisState<A> bwdTernarySemantics(InterproceduralAnalysis<A> interprocedural, AnalysisState<A> state, SymbolicExpression left, SymbolicExpression middle, SymbolicExpression right, StatementStore<A> expressions) throws SemanticException {
        return this.fwdTernarySemantics(interprocedural, state, left, middle, right, expressions);
    }
}

