/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program.cfg.statement;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.AnalysisState;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.StatementStore;
import it.unive.lisa.interprocedural.InterproceduralAnalysis;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.program.cfg.edge.Edge;
import it.unive.lisa.program.cfg.statement.call.Call;
import it.unive.lisa.util.datastructures.graph.code.CodeNode;
import java.util.Objects;

public abstract class Statement
implements CodeNode<CFG, Statement, Edge>,
ProgramPoint,
Comparable<Statement> {
    private final CFG cfg;
    private final CodeLocation location;

    protected Statement(CFG cfg, CodeLocation location) {
        Objects.requireNonNull(cfg, "Containing CFG cannot be null");
        Objects.requireNonNull(location, "The location of a statement cannot be null");
        this.cfg = cfg;
        this.location = location;
    }

    @Override
    public final CFG getCFG() {
        return this.cfg;
    }

    public boolean stopsExecution() {
        return false;
    }

    public boolean throwsError() {
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Statement st = (Statement)obj;
        if (this.location == null) {
            if (st.location == null) {
                return true;
            }
        } else if (!this.location.equals(st.location)) {
            return false;
        }
        return true;
    }

    public abstract String toString();

    public abstract <A extends AbstractState<A>> AnalysisState<A> forwardSemantics(AnalysisState<A> var1, InterproceduralAnalysis<A> var2, StatementStore<A> var3) throws SemanticException;

    public <A extends AbstractState<A>> AnalysisState<A> backwardSemantics(AnalysisState<A> exitState, InterproceduralAnalysis<A> interprocedural, StatementStore<A> expressions) throws SemanticException {
        return this.forwardSemantics(exitState, interprocedural, expressions);
    }

    @Override
    public CodeLocation getLocation() {
        return this.location;
    }

    @Override
    public final int compareTo(Statement o) {
        int cmp = this.location.compareTo(o.location);
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.getClass().getName().compareTo(o.getClass().getName());
        if (cmp != 0) {
            return cmp;
        }
        return this.compareSameClass(o);
    }

    protected abstract int compareSameClass(Statement var1);

    public final Statement getEvaluationPredecessor() {
        if (this instanceof Call) {
            Call original = (Call)this;
            while (original.getSource() != null) {
                original = original.getSource();
            }
            if (original != this) {
                return this.getStatementEvaluatedBefore(original);
            }
        }
        return this.getStatementEvaluatedBefore(this);
    }

    public Statement getStatementEvaluatedBefore(Statement other) {
        return null;
    }

    public final Statement getEvaluationSuccessor() {
        if (this instanceof Call) {
            Call original = (Call)this;
            while (original.getSource() != null) {
                original = original.getSource();
            }
            if (original != this) {
                return this.getStatementEvaluatedAfter(original);
            }
        }
        return this.getStatementEvaluatedAfter(this);
    }

    public Statement getStatementEvaluatedAfter(Statement other) {
        return null;
    }
}

