/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program.cfg.statement;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.AnalysisState;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.StatementStore;
import it.unive.lisa.analysis.lattices.ExpressionSet;
import it.unive.lisa.interprocedural.InterproceduralAnalysis;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.program.cfg.edge.Edge;
import it.unive.lisa.program.cfg.statement.Expression;
import it.unive.lisa.program.cfg.statement.Statement;
import it.unive.lisa.program.cfg.statement.evaluation.EvaluationOrder;
import it.unive.lisa.program.cfg.statement.evaluation.LeftToRightEvaluation;
import it.unive.lisa.util.datastructures.graph.GraphVisitor;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public abstract class NaryStatement
extends Statement {
    private final Expression[] subExpressions;
    private final String constructName;
    private final EvaluationOrder order;

    protected NaryStatement(CFG cfg, CodeLocation location, String constructName, Expression ... subExpressions) {
        this(cfg, location, constructName, LeftToRightEvaluation.INSTANCE, subExpressions);
    }

    protected NaryStatement(CFG cfg, CodeLocation location, String constructName, EvaluationOrder order, Expression ... subExpressions) {
        super(cfg, location);
        Objects.requireNonNull(subExpressions, "The array of sub-expressions of a statement cannot be null");
        for (int i = 0; i < subExpressions.length; ++i) {
            Objects.requireNonNull(subExpressions[i], "The " + i + "-th sub-expression of a statement cannot be null");
        }
        Objects.requireNonNull(constructName, "The name of the native construct of a statement cannot be null");
        Objects.requireNonNull(order, "The evaluation order of a statement cannot be null");
        this.constructName = constructName;
        this.order = order;
        this.subExpressions = subExpressions;
        for (Expression param : subExpressions) {
            param.setParentStatement(this);
        }
    }

    public final String getConstructName() {
        return this.constructName;
    }

    public final Expression[] getSubExpressions() {
        return this.subExpressions;
    }

    public EvaluationOrder getOrder() {
        return this.order;
    }

    @Override
    public final <V> boolean accept(GraphVisitor<CFG, Statement, Edge, V> visitor, V tool) {
        if (visitor.visitSubNodesFirst()) {
            for (Expression sub : this.subExpressions) {
                if (sub.accept(visitor, tool)) continue;
                return false;
            }
            return visitor.visit(tool, this.getCFG(), (Edge)((Object)this));
        }
        if (!visitor.visit(tool, this.getCFG(), (Edge)((Object)this))) {
            return false;
        }
        for (Expression sub : this.subExpressions) {
            if (sub.accept(visitor, tool)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return this.constructName + " " + StringUtils.join((Object[])this.getSubExpressions(), (String)", ");
    }

    @Override
    public Statement getStatementEvaluatedBefore(Statement other) {
        int len = this.subExpressions.length;
        if (other == this) {
            return len == 0 ? null : this.subExpressions[this.order.last(len)];
        }
        for (int i = 0; i < len; ++i) {
            if (this.subExpressions[i] != other) continue;
            if (i == this.order.first(len)) {
                return null;
            }
            return this.subExpressions[this.order.previous(i, len)];
        }
        return null;
    }

    @Override
    public Statement getStatementEvaluatedAfter(Statement other) {
        if (other == this) {
            return null;
        }
        int len = this.subExpressions.length;
        for (int i = 0; i < len; ++i) {
            if (this.subExpressions[i] != other) continue;
            if (i == this.order.last(len)) {
                return this;
            }
            return this.subExpressions[this.order.next(i, len)];
        }
        return null;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.constructName == null ? 0 : this.constructName.hashCode());
        result = 31 * result + Arrays.hashCode(this.subExpressions);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof NaryStatement)) {
            return false;
        }
        NaryStatement other = (NaryStatement)obj;
        if (this.constructName == null ? other.constructName != null : !this.constructName.equals(other.constructName)) {
            return false;
        }
        return Arrays.equals(this.subExpressions, other.subExpressions);
    }

    @Override
    protected int compareSameClass(Statement o) {
        NaryStatement other = (NaryStatement)o;
        int cmp = Integer.compare(this.subExpressions.length, other.subExpressions.length);
        if (cmp != 0) {
            return cmp;
        }
        for (int i = 0; i < this.subExpressions.length; ++i) {
            cmp = this.subExpressions[i].compareTo(other.subExpressions[i]);
            if (cmp == 0) continue;
            return cmp;
        }
        return this.compareSameClassAndParams(o);
    }

    protected abstract int compareSameClassAndParams(Statement var1);

    @Override
    public <A extends AbstractState<A>> AnalysisState<A> forwardSemantics(AnalysisState<A> entryState, InterproceduralAnalysis<A> interprocedural, StatementStore<A> expressions) throws SemanticException {
        ExpressionSet[] computed = new ExpressionSet[this.subExpressions.length];
        AnalysisState<A> eval = this.order.evaluate(this.subExpressions, entryState, interprocedural, expressions, computed);
        AnalysisState<A> result = this.forwardSemanticsAux(interprocedural, eval, computed, expressions);
        for (Expression sub : this.subExpressions) {
            result = result.forgetIdentifiers(sub.getMetaVariables());
        }
        return result;
    }

    public abstract <A extends AbstractState<A>> AnalysisState<A> forwardSemanticsAux(InterproceduralAnalysis<A> var1, AnalysisState<A> var2, ExpressionSet[] var3, StatementStore<A> var4) throws SemanticException;

    @Override
    public <A extends AbstractState<A>> AnalysisState<A> backwardSemantics(AnalysisState<A> exitState, InterproceduralAnalysis<A> interprocedural, StatementStore<A> expressions) throws SemanticException {
        ExpressionSet[] computed = new ExpressionSet[this.subExpressions.length];
        AnalysisState<A> sem = this.order.bwdEvaluate(this.subExpressions, exitState, interprocedural, expressions, computed);
        AnalysisState<A> result = this.backwardSemanticsAux(interprocedural, sem, computed, expressions);
        for (Expression sub : this.subExpressions) {
            result = result.forgetIdentifiers(sub.getMetaVariables());
        }
        return result;
    }

    public <A extends AbstractState<A>> AnalysisState<A> backwardSemanticsAux(InterproceduralAnalysis<A> interprocedural, AnalysisState<A> state, ExpressionSet[] params, StatementStore<A> expressions) throws SemanticException {
        return this.forwardSemanticsAux(interprocedural, state, params, expressions);
    }
}

