/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program.cfg.statement;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.AnalysisState;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.StatementStore;
import it.unive.lisa.analysis.lattices.ExpressionSet;
import it.unive.lisa.interprocedural.InterproceduralAnalysis;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.program.cfg.statement.Expression;
import it.unive.lisa.program.cfg.statement.NaryStatement;
import it.unive.lisa.program.cfg.statement.evaluation.EvaluationOrder;
import it.unive.lisa.symbolic.SymbolicExpression;

public abstract class BinaryStatement
extends NaryStatement {
    protected BinaryStatement(CFG cfg, CodeLocation location, String constructName, Expression left, Expression right) {
        super(cfg, location, constructName, left, right);
    }

    protected BinaryStatement(CFG cfg, CodeLocation location, String constructName, EvaluationOrder order, Expression left, Expression right) {
        super(cfg, location, constructName, order, left, right);
    }

    public Expression getLeft() {
        return this.getSubExpressions()[0];
    }

    public Expression getRight() {
        return this.getSubExpressions()[1];
    }

    @Override
    public <A extends AbstractState<A>> AnalysisState<A> forwardSemanticsAux(InterproceduralAnalysis<A> interprocedural, AnalysisState<A> state, ExpressionSet[] params, StatementStore<A> expressions) throws SemanticException {
        AnalysisState<A> result = state.bottom();
        for (SymbolicExpression left : params[0]) {
            for (SymbolicExpression right : params[1]) {
                result = result.lub(this.fwdBinarySemantics(interprocedural, state, left, right, expressions));
            }
        }
        return result;
    }

    public abstract <A extends AbstractState<A>> AnalysisState<A> fwdBinarySemantics(InterproceduralAnalysis<A> var1, AnalysisState<A> var2, SymbolicExpression var3, SymbolicExpression var4, StatementStore<A> var5) throws SemanticException;

    @Override
    public <A extends AbstractState<A>> AnalysisState<A> backwardSemanticsAux(InterproceduralAnalysis<A> interprocedural, AnalysisState<A> state, ExpressionSet[] params, StatementStore<A> expressions) throws SemanticException {
        AnalysisState<A> result = state.bottom();
        for (SymbolicExpression left : params[0]) {
            for (SymbolicExpression right : params[1]) {
                result = result.lub(this.bwdBinarySemantics(interprocedural, state, left, right, expressions));
            }
        }
        return result;
    }

    public <A extends AbstractState<A>> AnalysisState<A> bwdBinarySemantics(InterproceduralAnalysis<A> interprocedural, AnalysisState<A> state, SymbolicExpression left, SymbolicExpression right, StatementStore<A> expressions) throws SemanticException {
        return this.fwdBinarySemantics(interprocedural, state, left, right, expressions);
    }
}

