/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program.cfg.fixpoints;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.AnalysisState;
import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.edge.Edge;
import it.unive.lisa.program.cfg.fixpoints.CFGFixpoint;
import it.unive.lisa.program.cfg.statement.Statement;
import it.unive.lisa.util.collections.workset.WorkingSet;
import it.unive.lisa.util.datastructures.graph.algorithms.Fixpoint;
import it.unive.lisa.util.datastructures.graph.algorithms.FixpointException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Predicate;

public class OptimizedFixpoint<A extends AbstractState<A>>
extends Fixpoint<CFG, Statement, Edge, CFGFixpoint.CompoundState<A>> {
    private final Predicate<Statement> hotspots;

    public OptimizedFixpoint(CFG graph, boolean forceFullEvaluation, Predicate<Statement> hotspots) {
        super(graph, forceFullEvaluation);
        this.hotspots = hotspots;
    }

    @Override
    public Map<Statement, CFGFixpoint.CompoundState<A>> fixpoint(Map<Statement, CFGFixpoint.CompoundState<A>> startingPoints, WorkingSet<Statement> ws, Fixpoint.FixpointImplementation<Statement, Edge, CFGFixpoint.CompoundState<A>> implementation, Map<Statement, CFGFixpoint.CompoundState<A>> initialResult) throws FixpointException {
        HashMap<Statement, CFGFixpoint.CompoundState<A>> result = initialResult == null ? new HashMap<Statement, CFGFixpoint.CompoundState<A>>(((CFG)this.graph).getNodesCount()) : new HashMap<Statement, CFGFixpoint.CompoundState<A>>(initialResult);
        Map<Statement, Statement[]> bbs = ((CFG)this.graph).getBasicBlocks();
        startingPoints.keySet().forEach(ws::push);
        HashSet<Statement> toProcess = null;
        if (this.forceFullEvaluation) {
            toProcess = new HashSet<Statement>(bbs.keySet());
        }
        while (!ws.isEmpty()) {
            Statement current = ws.pop();
            if (current == null) {
                throw new FixpointException("null node encountered during fixpoint in '" + this.graph + "'");
            }
            if (!((CFG)this.graph).containsNode(current)) {
                throw new FixpointException("'" + current + "' is not part of '" + this.graph + "'");
            }
            Statement[] bb = bbs.get(current);
            if (bb == null) {
                throw new FixpointException("'" + current + "' is not the leader of a basic block of '" + this.graph + "'");
            }
            CFGFixpoint.CompoundState<A> entrystate = this.getEntryState(current, startingPoints.get(current), implementation, result);
            if (entrystate == null) {
                throw new FixpointException("'" + current + "' does not have an entry state");
            }
            CFGFixpoint.CompoundState newApprox = this.analyze(result, implementation, entrystate, bb);
            Statement closing = bb[bb.length - 1];
            CFGFixpoint.CompoundState oldApprox = (CFGFixpoint.CompoundState)result.get(closing);
            if (oldApprox != null) {
                try {
                    newApprox = implementation.operation(closing, newApprox, oldApprox);
                }
                catch (Exception e) {
                    throw new FixpointException(String.format("Exception while %s of '%s' in '%s'", "joining states", closing, this.graph), e);
                }
            }
            try {
                if ((!this.forceFullEvaluation || !toProcess.remove(current)) && oldApprox != null && implementation.equality(closing, newApprox, oldApprox)) continue;
                result.put(closing, newApprox);
                for (Statement instr : ((CFG)this.graph).followersOf(closing)) {
                    ws.push(instr);
                }
            }
            catch (Exception e) {
                throw new FixpointException(String.format("Exception while %s of '%s' in '%s'", "updating result", closing, this.graph), e);
            }
        }
        HashSet<Statement> cleanup = new HashSet<Statement>();
        Collection<Statement> wideningPoints = ((CFG)this.graph).getCycleEntries();
        for (Statement st : result.keySet()) {
            if (wideningPoints.contains(st) || st.stopsExecution() || this.hotspots != null && this.hotspots.test(st)) continue;
            cleanup.add(st);
        }
        cleanup.forEach(result::remove);
        return result;
    }

    private CFGFixpoint.CompoundState<A> analyze(Map<Statement, CFGFixpoint.CompoundState<A>> result, Fixpoint.FixpointImplementation<Statement, Edge, CFGFixpoint.CompoundState<A>> implementation, CFGFixpoint.CompoundState<A> entrystate, Statement[] bb) throws FixpointException {
        Lattice emptyIntermediate = entrystate.intermediateStates.bottom();
        CFGFixpoint.CompoundState newApprox = CFGFixpoint.CompoundState.of(entrystate.postState.bottom(), emptyIntermediate);
        CFGFixpoint.CompoundState<A> entry = entrystate;
        for (Statement cursor : bb) {
            try {
                newApprox = implementation.semantics(cursor, entry);
                for (Map.Entry entry2 : newApprox.intermediateStates) {
                    if (!((Statement)entry2.getKey()).stopsExecution() && (this.hotspots == null || !this.hotspots.test((Statement)entry2.getKey()))) continue;
                    result.put((Statement)entry2.getKey(), CFGFixpoint.CompoundState.of((AnalysisState)entry2.getValue(), emptyIntermediate));
                }
                if (cursor != bb[bb.length - 1] && (cursor.stopsExecution() || this.hotspots != null && this.hotspots.test(cursor))) {
                    result.put(cursor, CFGFixpoint.CompoundState.of(newApprox.postState, emptyIntermediate));
                }
                entry = newApprox;
            }
            catch (Exception e) {
                throw new FixpointException(String.format("Exception while %s of '%s' in '%s'", "computing semantics", cursor, this.graph), e);
            }
        }
        return CFGFixpoint.CompoundState.of(newApprox.postState, emptyIntermediate);
    }
}

