/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program.cfg.fixpoints;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.AnalysisState;
import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.edge.Edge;
import it.unive.lisa.program.cfg.fixpoints.CFGFixpoint;
import it.unive.lisa.program.cfg.statement.Statement;
import it.unive.lisa.util.collections.workset.WorkingSet;
import it.unive.lisa.util.datastructures.graph.algorithms.BackwardFixpoint;
import it.unive.lisa.util.datastructures.graph.algorithms.Fixpoint;
import it.unive.lisa.util.datastructures.graph.algorithms.FixpointException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Predicate;

public class OptimizedBackwardFixpoint<A extends AbstractState<A>>
extends BackwardFixpoint<CFG, Statement, Edge, CFGFixpoint.CompoundState<A>> {
    private final Predicate<Statement> hotspots;

    public OptimizedBackwardFixpoint(CFG graph, boolean forceFullEvaluation, Predicate<Statement> hotspots) {
        super(graph, forceFullEvaluation);
        this.hotspots = hotspots;
    }

    @Override
    public Map<Statement, CFGFixpoint.CompoundState<A>> fixpoint(Map<Statement, CFGFixpoint.CompoundState<A>> startingPoints, WorkingSet<Statement> ws, Fixpoint.FixpointImplementation<Statement, Edge, CFGFixpoint.CompoundState<A>> implementation, Map<Statement, CFGFixpoint.CompoundState<A>> initialResult) throws FixpointException {
        HashMap<Statement, CFGFixpoint.CompoundState<A>> result = initialResult == null ? new HashMap<Statement, CFGFixpoint.CompoundState<A>>(((CFG)this.graph).getNodesCount()) : new HashMap<Statement, CFGFixpoint.CompoundState<A>>(initialResult);
        HashMap<Statement, Statement[]> bbs = new HashMap<Statement, Statement[]>();
        for (Map.Entry<Statement, Statement[]> bb : ((CFG)this.graph).getBasicBlocks().entrySet()) {
            Statement[] block = bb.getValue();
            bbs.put(block[block.length - 1], block);
        }
        startingPoints.keySet().forEach(ws::push);
        HashSet toProcess = null;
        if (this.forceFullEvaluation) {
            toProcess = new HashSet(bbs.keySet());
        }
        while (!ws.isEmpty()) {
            Statement current = ws.pop();
            if (current == null) {
                throw new FixpointException("null node encountered during fixpoint in '" + this.graph + "'");
            }
            if (!((CFG)this.graph).containsNode(current)) {
                throw new FixpointException("'" + current + "' is not part of '" + this.graph + "'");
            }
            Statement[] bb = (Statement[])bbs.get(current);
            if (bb == null) {
                throw new FixpointException("'" + current + "' is not the leader of a basic block of '" + this.graph + "'");
            }
            CFGFixpoint.CompoundState<A> exitstate = this.getExitState(current, startingPoints.get(current), implementation, result);
            if (exitstate == null) {
                throw new FixpointException("'" + current + "' does not have an entry state");
            }
            CFGFixpoint.CompoundState newApprox = this.analyze(result, implementation, exitstate, bb);
            Statement leader = bb[0];
            CFGFixpoint.CompoundState oldApprox = (CFGFixpoint.CompoundState)result.get(leader);
            if (oldApprox != null) {
                try {
                    newApprox = implementation.operation(leader, newApprox, oldApprox);
                }
                catch (Exception e) {
                    throw new FixpointException(String.format("Exception while %s of '%s' in '%s'", "joining states", leader, this.graph), e);
                }
            }
            try {
                if ((!this.forceFullEvaluation || !toProcess.remove(current)) && oldApprox != null && implementation.equality(leader, newApprox, oldApprox)) continue;
                result.put(leader, newApprox);
                for (Statement instr : ((CFG)this.graph).predecessorsOf(leader)) {
                    ws.push(instr);
                }
            }
            catch (Exception e) {
                throw new FixpointException(String.format("Exception while %s of '%s' in '%s'", "updating result", leader, this.graph), e);
            }
        }
        HashSet<Statement> cleanup = new HashSet<Statement>();
        Collection<Statement> wideningPoints = ((CFG)this.graph).getCycleEntries();
        for (Statement st : result.keySet()) {
            if (wideningPoints.contains(st) || st.stopsExecution() || this.hotspots != null && this.hotspots.test(st)) continue;
            cleanup.add(st);
        }
        cleanup.forEach(result::remove);
        return result;
    }

    private CFGFixpoint.CompoundState<A> analyze(Map<Statement, CFGFixpoint.CompoundState<A>> result, Fixpoint.FixpointImplementation<Statement, Edge, CFGFixpoint.CompoundState<A>> implementation, CFGFixpoint.CompoundState<A> exitstate, Statement[] bb) throws FixpointException {
        Lattice emptyIntermediate = exitstate.intermediateStates.bottom();
        CFGFixpoint.CompoundState newApprox = CFGFixpoint.CompoundState.of(exitstate.postState.bottom(), emptyIntermediate);
        CFGFixpoint.CompoundState<A> exit = exitstate;
        for (int i = bb.length - 1; i >= 0; --i) {
            try {
                Statement cursor = bb[i];
                newApprox = implementation.semantics(cursor, exit);
                for (Map.Entry entry : newApprox.intermediateStates) {
                    if (!((Statement)entry.getKey()).stopsExecution() && (this.hotspots == null || !this.hotspots.test((Statement)entry.getKey()))) continue;
                    result.put((Statement)entry.getKey(), CFGFixpoint.CompoundState.of((AnalysisState)entry.getValue(), emptyIntermediate));
                }
                if (cursor != bb[0] && (cursor.stopsExecution() || this.hotspots != null && this.hotspots.test(cursor))) {
                    result.put(cursor, CFGFixpoint.CompoundState.of(newApprox.postState, emptyIntermediate));
                }
                exit = newApprox;
                continue;
            }
            catch (Exception e) {
                throw new FixpointException(String.format("Exception while %s of '%s' in '%s'", "computing semantics", bb[i], this.graph), e);
            }
        }
        return CFGFixpoint.CompoundState.of(newApprox.postState, emptyIntermediate);
    }
}

