/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program.cfg.fixpoints;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.AnalysisState;
import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.StatementStore;
import it.unive.lisa.interprocedural.InterproceduralAnalysis;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.VariableTableEntry;
import it.unive.lisa.program.cfg.edge.Edge;
import it.unive.lisa.program.cfg.statement.Expression;
import it.unive.lisa.program.cfg.statement.Statement;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.Variable;
import it.unive.lisa.util.datastructures.graph.algorithms.Fixpoint;
import it.unive.lisa.util.representation.ListRepresentation;
import it.unive.lisa.util.representation.StructuredRepresentation;
import java.util.LinkedList;
import org.apache.commons.lang3.StringUtils;

public abstract class CFGFixpoint<A extends AbstractState<A>>
implements Fixpoint.FixpointImplementation<Statement, Edge, CompoundState<A>> {
    protected final CFG graph;
    protected final InterproceduralAnalysis<A> interprocedural;

    public CFGFixpoint(CFG graph, InterproceduralAnalysis<A> interprocedural) {
        this.graph = graph;
        this.interprocedural = interprocedural;
    }

    @Override
    public CompoundState<A> semantics(Statement node, CompoundState<A> entrystate) throws SemanticException {
        StatementStore expressions = new StatementStore(entrystate.postState.bottom());
        AnalysisState approx = node.forwardSemantics(entrystate.postState, this.interprocedural, expressions);
        if (node instanceof Expression) {
            approx = approx.forgetIdentifiers(((Expression)node).getMetaVariables());
        }
        return CompoundState.of(approx, expressions);
    }

    @Override
    public CompoundState<A> traverse(Edge edge, CompoundState<A> entrystate) throws SemanticException {
        AnalysisState approx = edge.traverseForward(entrystate.postState);
        LinkedList<VariableTableEntry> toRemove = new LinkedList<VariableTableEntry>();
        for (VariableTableEntry entry : this.graph.getDescriptor().getVariables()) {
            if (entry.getScopeEnd() != edge.getSource()) continue;
            toRemove.add(entry);
        }
        LinkedList<Identifier> ids = new LinkedList<Identifier>();
        for (VariableTableEntry entry : toRemove) {
            Variable v = entry.createReference(this.graph).getVariable();
            for (SymbolicExpression expr : approx.smallStepSemantics(v, edge.getSource()).getComputedExpressions()) {
                ids.add((Identifier)expr);
            }
        }
        if (!ids.isEmpty()) {
            approx = approx.forgetIdentifiers(ids);
        }
        return CompoundState.of(approx, new StatementStore(approx.bottom()));
    }

    @Override
    public CompoundState<A> union(Statement node, CompoundState<A> left, CompoundState<A> right) throws SemanticException {
        return left.lub(right);
    }

    public static final class CompoundState<A extends AbstractState<A>>
    implements Lattice<CompoundState<A>> {
        public final AnalysisState<A> postState;
        public final StatementStore<A> intermediateStates;

        public static <A extends AbstractState<A>> CompoundState<A> of(AnalysisState<A> postState, StatementStore<A> intermediateStates) {
            return new CompoundState<A>(postState, intermediateStates);
        }

        private CompoundState(AnalysisState<A> postState, StatementStore<A> intermediateStates) {
            this.postState = postState;
            this.intermediateStates = intermediateStates;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.intermediateStates == null ? 0 : this.intermediateStates.hashCode());
            result = 31 * result + (this.postState == null ? 0 : this.postState.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CompoundState other = (CompoundState)obj;
            if (this.intermediateStates == null ? other.intermediateStates != null : !this.intermediateStates.equals(other.intermediateStates)) {
                return false;
            }
            return !(this.postState == null ? other.postState != null : !this.postState.equals(other.postState));
        }

        public String toString() {
            return this.postState + "\n[" + StringUtils.join(this.intermediateStates, (String)"\n") + "]";
        }

        @Override
        public boolean lessOrEqual(CompoundState<A> other) throws SemanticException {
            return this.postState.lessOrEqual(other.postState) && this.intermediateStates.lessOrEqual(other.intermediateStates);
        }

        @Override
        public CompoundState<A> lub(CompoundState<A> other) throws SemanticException {
            return CompoundState.of(this.postState.lub(other.postState), this.intermediateStates.lub(other.intermediateStates));
        }

        @Override
        public CompoundState<A> top() {
            return CompoundState.of(this.postState.top(), this.intermediateStates.top());
        }

        @Override
        public boolean isTop() {
            return this.postState.isTop() && this.intermediateStates.isTop();
        }

        @Override
        public CompoundState<A> bottom() {
            return CompoundState.of(this.postState.bottom(), this.intermediateStates.bottom());
        }

        @Override
        public boolean isBottom() {
            return this.postState.isBottom() && this.intermediateStates.isBottom();
        }

        @Override
        public CompoundState<A> glb(CompoundState<A> other) throws SemanticException {
            return CompoundState.of(this.postState.glb(other.postState), this.intermediateStates.glb(other.intermediateStates));
        }

        @Override
        public CompoundState<A> narrowing(CompoundState<A> other) throws SemanticException {
            return CompoundState.of(this.postState.narrowing(other.postState), this.intermediateStates.narrowing(other.intermediateStates));
        }

        @Override
        public CompoundState<A> widening(CompoundState<A> other) throws SemanticException {
            return CompoundState.of(this.postState.widening(other.postState), this.intermediateStates.widening(other.intermediateStates));
        }

        @Override
        public StructuredRepresentation representation() {
            return new ListRepresentation(this.postState.representation(), this.intermediateStates.representation());
        }
    }
}

