/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program.cfg.fixpoints;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.AnalysisState;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.StatementStore;
import it.unive.lisa.conf.FixpointConfiguration;
import it.unive.lisa.interprocedural.InterproceduralAnalysis;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.fixpoints.BackwardCFGFixpoint;
import it.unive.lisa.program.cfg.fixpoints.CFGFixpoint;
import it.unive.lisa.program.cfg.statement.Statement;
import java.util.Collection;

public class BackwardDescendingNarrowingFixpoint<A extends AbstractState<A>>
extends BackwardCFGFixpoint<A> {
    private final FixpointConfiguration config;
    private final Collection<Statement> wideningPoints;

    public BackwardDescendingNarrowingFixpoint(CFG target, InterproceduralAnalysis<A> interprocedural, FixpointConfiguration config) {
        super(target, interprocedural);
        this.config = config;
        this.wideningPoints = config.useWideningPoints ? target.getCycleEntries() : null;
    }

    @Override
    public CFGFixpoint.CompoundState<A> operation(Statement node, CFGFixpoint.CompoundState<A> approx, CFGFixpoint.CompoundState<A> old) throws SemanticException {
        if (this.wideningPoints == null || !this.wideningPoints.contains(node)) {
            return old.glb(approx);
        }
        AnalysisState post = old.postState.narrowing(approx.postState);
        StatementStore intermediate = this.config.useWideningPoints ? old.intermediateStates.glb(approx.intermediateStates) : old.intermediateStates.narrowing(approx.intermediateStates);
        return CFGFixpoint.CompoundState.of(post, intermediate);
    }

    @Override
    public boolean equality(Statement node, CFGFixpoint.CompoundState<A> approx, CFGFixpoint.CompoundState<A> old) throws SemanticException {
        return old.lessOrEqual(approx);
    }
}

