/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program.cfg.fixpoints;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.conf.FixpointConfiguration;
import it.unive.lisa.interprocedural.InterproceduralAnalysis;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.fixpoints.BackwardCFGFixpoint;
import it.unive.lisa.program.cfg.fixpoints.CFGFixpoint;
import it.unive.lisa.program.cfg.statement.Statement;
import java.util.HashMap;
import java.util.Map;

public class BackwardDescendingGLBFixpoint<A extends AbstractState<A>>
extends BackwardCFGFixpoint<A> {
    private final int maxGLBs;
    private final Map<Statement, Integer> glbs;

    public BackwardDescendingGLBFixpoint(CFG target, InterproceduralAnalysis<A> interprocedural, FixpointConfiguration config) {
        super(target, interprocedural);
        this.maxGLBs = config.glbThreshold;
        this.glbs = new HashMap<Statement, Integer>(target.getNodesCount());
    }

    @Override
    public CFGFixpoint.CompoundState<A> operation(Statement node, CFGFixpoint.CompoundState<A> approx, CFGFixpoint.CompoundState<A> old) throws SemanticException {
        if (this.maxGLBs < 0) {
            return old;
        }
        int glb = this.glbs.computeIfAbsent(node, st -> this.maxGLBs);
        if (glb == 0) {
            return old;
        }
        this.glbs.put(node, --glb);
        return old.glb(approx);
    }

    @Override
    public boolean equality(Statement node, CFGFixpoint.CompoundState<A> approx, CFGFixpoint.CompoundState<A> old) throws SemanticException {
        return old.lessOrEqual(approx);
    }
}

