/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program.cfg.fixpoints;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.AnalysisState;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.StatementStore;
import it.unive.lisa.interprocedural.InterproceduralAnalysis;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.VariableTableEntry;
import it.unive.lisa.program.cfg.edge.Edge;
import it.unive.lisa.program.cfg.fixpoints.CFGFixpoint;
import it.unive.lisa.program.cfg.statement.Expression;
import it.unive.lisa.program.cfg.statement.Statement;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.Variable;
import it.unive.lisa.util.datastructures.graph.algorithms.Fixpoint;
import java.util.LinkedList;

public abstract class BackwardCFGFixpoint<A extends AbstractState<A>>
implements Fixpoint.FixpointImplementation<Statement, Edge, CFGFixpoint.CompoundState<A>> {
    protected final CFG graph;
    protected final InterproceduralAnalysis<A> interprocedural;

    public BackwardCFGFixpoint(CFG graph, InterproceduralAnalysis<A> interprocedural) {
        this.graph = graph;
        this.interprocedural = interprocedural;
    }

    @Override
    public CFGFixpoint.CompoundState<A> semantics(Statement node, CFGFixpoint.CompoundState<A> entrystate) throws SemanticException {
        StatementStore expressions = new StatementStore(entrystate.postState.bottom());
        AnalysisState approx = node.backwardSemantics(entrystate.postState, this.interprocedural, expressions);
        if (node instanceof Expression) {
            approx = approx.forgetIdentifiers(((Expression)node).getMetaVariables());
        }
        return CFGFixpoint.CompoundState.of(approx, expressions);
    }

    @Override
    public CFGFixpoint.CompoundState<A> traverse(Edge edge, CFGFixpoint.CompoundState<A> entrystate) throws SemanticException {
        AnalysisState approx = edge.traverseBackwards(entrystate.postState);
        LinkedList<VariableTableEntry> toRemove = new LinkedList<VariableTableEntry>();
        for (VariableTableEntry entry : this.graph.getDescriptor().getVariables()) {
            if (entry.getScopeStart() != edge.getDestination()) continue;
            toRemove.add(entry);
        }
        LinkedList<Identifier> ids = new LinkedList<Identifier>();
        for (VariableTableEntry entry : toRemove) {
            Variable v = entry.createReference(this.graph).getVariable();
            for (SymbolicExpression expr : approx.smallStepSemantics(v, edge.getSource()).getComputedExpressions()) {
                ids.add((Identifier)expr);
            }
        }
        if (!ids.isEmpty()) {
            approx = approx.forgetIdentifiers(ids);
        }
        return CFGFixpoint.CompoundState.of(approx, new StatementStore(approx.bottom()));
    }

    @Override
    public CFGFixpoint.CompoundState<A> union(Statement node, CFGFixpoint.CompoundState<A> left, CFGFixpoint.CompoundState<A> right) throws SemanticException {
        return left.lub(right);
    }
}

