/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program.cfg.fixpoints;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.AnalysisState;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.StatementStore;
import it.unive.lisa.conf.FixpointConfiguration;
import it.unive.lisa.interprocedural.InterproceduralAnalysis;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.fixpoints.BackwardCFGFixpoint;
import it.unive.lisa.program.cfg.fixpoints.CFGFixpoint;
import it.unive.lisa.program.cfg.statement.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class BackwardAscendingFixpoint<A extends AbstractState<A>>
extends BackwardCFGFixpoint<A> {
    private final FixpointConfiguration config;
    private final Map<Statement, Integer> lubs;
    private final Collection<Statement> wideningPoints;

    public BackwardAscendingFixpoint(CFG target, InterproceduralAnalysis<A> interprocedural, FixpointConfiguration config) {
        super(target, interprocedural);
        this.config = config;
        this.wideningPoints = config.useWideningPoints ? target.getCycleEntries() : null;
        this.lubs = new HashMap<Statement, Integer>(config.useWideningPoints ? this.wideningPoints.size() : target.getNodesCount());
    }

    @Override
    public CFGFixpoint.CompoundState<A> operation(Statement node, CFGFixpoint.CompoundState<A> approx, CFGFixpoint.CompoundState<A> old) throws SemanticException {
        if (this.config.wideningThreshold < 0) {
            return old.lub(approx);
        }
        if (this.config.useWideningPoints && !this.wideningPoints.contains(node)) {
            return old.lub(approx);
        }
        int lub = this.lubs.computeIfAbsent(node, st -> this.config.wideningThreshold);
        if (lub == 0) {
            AnalysisState post = old.postState.widening(approx.postState);
            StatementStore intermediate = this.config.useWideningPoints ? old.intermediateStates.lub(approx.intermediateStates) : old.intermediateStates.widening(approx.intermediateStates);
            return CFGFixpoint.CompoundState.of(post, intermediate);
        }
        this.lubs.put(node, --lub);
        return old.lub(approx);
    }

    @Override
    public boolean equality(Statement node, CFGFixpoint.CompoundState<A> approx, CFGFixpoint.CompoundState<A> old) throws SemanticException {
        return approx.lessOrEqual(old);
    }
}

