/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.program.cfg.edge;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.AnalysisState;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.lattices.ExpressionSet;
import it.unive.lisa.program.cfg.edge.Edge;
import it.unive.lisa.program.cfg.statement.Statement;
import it.unive.lisa.symbolic.SymbolicExpression;

public class TrueEdge
extends Edge {
    public TrueEdge(Statement source, Statement destination) {
        super(source, destination);
    }

    @Override
    public String toString() {
        return "[ " + this.getSource() + " ] -T-> [ " + this.getDestination() + " ]";
    }

    @Override
    public <A extends AbstractState<A>> AnalysisState<A> traverseForward(AnalysisState<A> state) throws SemanticException {
        ExpressionSet exprs = state.getComputedExpressions();
        AnalysisState<A> result = state.bottom();
        for (SymbolicExpression expr : exprs) {
            result = result.lub(state.assume(expr, this.getSource(), this.getDestination()));
        }
        return result;
    }

    @Override
    public <A extends AbstractState<A>> AnalysisState<A> traverseBackwards(AnalysisState<A> state) throws SemanticException {
        return this.traverseForward(state);
    }

    @Override
    public boolean isUnconditional() {
        return false;
    }

    @Override
    public TrueEdge newInstance(Statement source, Statement destination) {
        return new TrueEdge(source, destination);
    }
}

